/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.path.json;

import com.google.gson.JsonArray;
import java.util.List;
import java.util.Objects;
import org.aksw.commons.path.core.PathBase;
import org.aksw.commons.path.core.PathOps;
import org.aksw.commons.path.json.PathOpsJson;

public class PathJson
extends PathBase<Step, PathJson> {
    private static final long serialVersionUID = 1L;

    public PathJson(PathOps<Step, PathJson> pathOps, boolean isAbsolute, List<Step> segments) {
        super(pathOps, isAbsolute, segments);
    }

    public JsonArray toJsonArray() {
        return PathOpsJson.toJsonArray(this);
    }

    public static PathJson parse(String str) {
        return PathOpsJson.get().fromString(str);
    }

    public static PathJson newAbsolutePath(Step segment) {
        return (PathJson)PathOpsJson.get().newAbsolutePath(segment);
    }

    public static PathJson newAbsolutePath(Step ... segments) {
        return (PathJson)PathOpsJson.get().newAbsolutePath((T[])segments);
    }

    public static PathJson newAbsolutePath(List<Step> segments) {
        return (PathJson)PathOpsJson.get().newAbsolutePath(segments);
    }

    public static PathJson newRelativePath(Step segment) {
        return (PathJson)PathOpsJson.get().newRelativePath(segment);
    }

    public static PathJson newRelativePath(Step ... segments) {
        return (PathJson)PathOpsJson.get().newRelativePath((T[])segments);
    }

    public static PathJson newRelativePath(List<Step> segments) {
        return (PathJson)PathOpsJson.get().newRelativePath(segments);
    }

    public static class StepIndex
    implements Step {
        protected final int index;

        protected StepIndex(int index) {
            this.index = index;
        }

        @Override
        public boolean isIndex() {
            return true;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        public int hashCode() {
            return Objects.hash(this.index);
        }

        public String toString() {
            return Integer.toString(this.index);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StepIndex other = (StepIndex)obj;
            return this.index == other.index;
        }
    }

    public static class StepKey
    implements Step {
        protected final String key;

        protected StepKey(String key) {
            this.key = key;
        }

        @Override
        public boolean isKey() {
            return true;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        public String toString() {
            return this.key;
        }

        public int hashCode() {
            return Objects.hash(this.key);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StepKey other = (StepKey)obj;
            return Objects.equals(this.key, other.key);
        }
    }

    public static interface Step
    extends Comparable<Step> {
        default public boolean isKey() {
            return false;
        }

        default public boolean isIndex() {
            return false;
        }

        default public String getKey() {
            throw new UnsupportedOperationException();
        }

        default public int getIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        default public int compareTo(Step that) {
            return Objects.toString(this).compareTo(Objects.toString(that));
        }

        public static StepIndex of(int index) {
            return new StepIndex(index);
        }

        public static StepKey of(String key) {
            return new StepKey(key);
        }

        public static StepKey self() {
            return new StepKey("---self---");
        }

        public static StepKey parent() {
            return new StepKey("---parent---");
        }
    }
}

