/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.path.core;

import java.nio.file.FileSystem;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.StreamSupport;
import org.aksw.commons.path.core.Path;

public class PathNio
implements Path<String> {
    protected java.nio.file.Path delegate;

    protected PathNio(java.nio.file.Path delegate) {
        this.delegate = delegate;
    }

    public java.nio.file.Path getDelegate() {
        return this.delegate;
    }

    public static PathNio wrap(java.nio.file.Path nioPath) {
        return new PathNio(nioPath);
    }

    protected PathNio wrapInternal(java.nio.file.Path nioPath) {
        return new PathNio(nioPath);
    }

    @Override
    public Path<String> toAbsolutePath() {
        return this.wrapInternal(this.getDelegate().toAbsolutePath());
    }

    @Override
    public boolean isAbsolute() {
        return this.getDelegate().isAbsolute();
    }

    @Override
    public List<String> getSegments() {
        int n = this.getDelegate().getNameCount();
        String[] result = new String[n];
        Iterator<java.nio.file.Path> it = this.getDelegate().iterator();
        for (int i = 0; i < n; ++i) {
            String segment;
            result[i] = segment = it.next().toString();
        }
        return Arrays.asList(result);
    }

    @Override
    public Path<String> getRoot() {
        return this.wrapInternal(this.getDelegate().getRoot());
    }

    @Override
    public Path<String> getFileName() {
        return this.wrapInternal(this.getDelegate().getFileName());
    }

    @Override
    public Path<String> getParent() {
        return this.wrapInternal(this.getDelegate().getParent());
    }

    @Override
    public int getNameCount() {
        return this.getDelegate().getNameCount();
    }

    @Override
    public Path<String> getName(int index) {
        return this.wrapInternal(this.getDelegate().getName(index));
    }

    @Override
    public Path<String> subpath(int beginIndex, int endIndex) {
        return this.wrapInternal(this.getDelegate().subpath(beginIndex, endIndex));
    }

    @Override
    public Path<String> subpath(int beginIndex) {
        int endIndex = this.getNameCount();
        return this.subpath(beginIndex, endIndex);
    }

    @Override
    public boolean startsWith(Path<String> other) {
        return this.getDelegate().startsWith(((PathNio)other).getDelegate());
    }

    @Override
    public boolean endsWith(Path<String> other) {
        return this.getDelegate().endsWith(((PathNio)other).getDelegate());
    }

    @Override
    public Path<String> normalize() {
        return this.wrapInternal(this.getDelegate().normalize());
    }

    @Override
    public Path<String> resolve(String other) {
        return this.resolveStr(other);
    }

    @Override
    public Path<String> resolveStr(String other) {
        return this.wrapInternal(this.getDelegate().resolve(other));
    }

    @Override
    public Path<String> resolve(Path<String> other) {
        return this.wrapInternal(this.getDelegate().resolve(((PathNio)other).getDelegate()));
    }

    @Override
    public Path<String> resolveSibling(String other) {
        return this.resolveSiblingStr(other);
    }

    @Override
    public Path<String> resolveSiblingStr(String other) {
        return this.wrapInternal(this.getDelegate().resolveSibling(other));
    }

    @Override
    public Path<String> resolveSibling(Path<String> other) {
        return this.wrapInternal(this.getDelegate().resolveSibling(((PathNio)other).getDelegate()));
    }

    @Override
    public Path<String> relativize(Path<String> other) {
        return this.wrapInternal(this.getDelegate().relativize(((PathNio)other).getDelegate()));
    }

    @Override
    public Iterator<Path<String>> iterator() {
        Iterable iterable = () -> this.getDelegate().iterator();
        return StreamSupport.stream(iterable.spliterator(), false).map(this::wrapInternal).map(item -> item).iterator();
    }

    @Override
    public int compareTo(Path<String> that) {
        return Comparator.nullsFirst((x, y) -> x.toString().compareTo(y.toString())).compare(this, that);
    }

    @Override
    public FileSystem getSystem() {
        return this.getDelegate().getFileSystem();
    }
}

