/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.path.core;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import org.aksw.commons.path.core.Path;
import org.aksw.commons.path.core.PathOps;

public class PathBase<T, P extends Path<T>>
implements Path<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected boolean isAbsolute;
    protected transient List<T> segments;
    protected transient List<T> segmentsView;
    protected PathOps<T, P> pathOps;

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        this.pathOps = (PathOps)in.readObject();
        String str = in.readUTF();
        PathBase tmp = (PathBase)this.pathOps.fromString(str);
        this.isAbsolute = tmp.isAbsolute;
        this.segments = tmp.segments;
        this.segmentsView = Collections.unmodifiableList(this.segments);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.pathOps);
        out.writeUTF(this.pathOps.toStringRaw(this));
    }

    PathBase() {
    }

    public PathBase(PathOps<T, P> pathOps, boolean isAbsolute, List<T> segments) {
        this.pathOps = pathOps;
        this.isAbsolute = isAbsolute;
        this.segments = segments;
        this.segmentsView = Collections.unmodifiableList(segments);
    }

    protected P newPath(boolean isAbsolute, List<T> segments) {
        return this.getPathOps().newPath(isAbsolute, segments);
    }

    public PathOps<T, P> getPathOps() {
        return this.pathOps;
    }

    public P toAbsolutePath() {
        P basePath = this.newPath(true, this.getPathOps().getBasePathSegments());
        Path result = basePath.resolve(this);
        return (P)result;
    }

    @Override
    public boolean isAbsolute() {
        return this.isAbsolute;
    }

    public P getRoot() {
        return this.newPath(true, Collections.emptyList());
    }

    public P getFileName() {
        P result = this.segments.isEmpty() ? null : (P)this.newPath(false, Collections.singletonList(this.segments.get(this.segments.size() - 1)));
        return result;
    }

    public P getParent() {
        P result = this.segments.isEmpty() ? null : (P)this.newPath(this.isAbsolute(), this.segments.subList(0, this.segments.size() - 1));
        return result;
    }

    @Override
    public int getNameCount() {
        return this.segments.size();
    }

    public P getName(int index) {
        return this.newPath(false, Collections.singletonList(this.segments.get(index)));
    }

    public P subpath(int beginIndex, int endIndex) {
        return this.newPath(false, this.segments.subList(beginIndex, endIndex));
    }

    public P subpath(int beginIndex) {
        int endIndex = this.getNameCount();
        return this.subpath(beginIndex, endIndex);
    }

    @Override
    public boolean startsWith(Path<T> other) {
        boolean result;
        int n = other.getNameCount();
        if (n <= this.getNameCount()) {
            result = true;
            List<T> otherSegments = other.getSegments();
            Iterator<T> thisIt = this.segments.iterator();
            Iterator<T> otherIt = otherSegments.iterator();
            for (int i = 0; i < n; ++i) {
                T otherPart;
                T thisPart = thisIt.next();
                if (Objects.equals(thisPart, otherPart = otherIt.next())) continue;
                result = false;
                break;
            }
        } else {
            result = false;
        }
        return result;
    }

    @Override
    public boolean endsWith(Path<T> other) {
        throw new UnsupportedOperationException("not implemented");
    }

    public P normalize() {
        ArrayList<T> tmp = new ArrayList<T>();
        for (T item : this.segments) {
            if (this.isParentToken(item)) {
                if (!tmp.isEmpty()) {
                    ListIterator delIt = tmp.listIterator(tmp.size());
                    Object seenItem = delIt.previous();
                    if (this.isParentToken(seenItem)) {
                        tmp.add(item);
                        continue;
                    }
                    delIt.remove();
                    continue;
                }
                tmp.add(item);
                continue;
            }
            tmp.add(item);
        }
        return this.newPath(this.isAbsolute(), tmp);
    }

    protected boolean isParentToken(T item) {
        T parentToken = this.getPathOps().getParentToken();
        int v = this.getPathOps().getComparator().compare(item, parentToken);
        return v == 0;
    }

    public static <T> List<T> toList(Path<T> path) {
        int n = path.getNameCount();
        ArrayList<T> result = new ArrayList<T>(n);
        for (int i = 0; i < n; ++i) {
            Path<T> tmp = path.getName(i);
            T segment = tmp.getSegments().get(0);
            result.add(segment);
        }
        return result;
    }

    public P resolveStr(String other) {
        return this.resolve(this.getPathOps().fromString(other));
    }

    public P resolve(Path<T> other) {
        P result;
        if (other.isAbsolute()) {
            result = this.getPathOps().upcast(other);
        } else {
            ArrayList<T> newSteps = new ArrayList<T>(this.segments.size() + other.getNameCount());
            newSteps.addAll(this.segments);
            newSteps.addAll(PathBase.toList(other));
            result = this.newPath(this.isAbsolute, newSteps);
        }
        return result;
    }

    public P relativize(Path<T> other) {
        return this.newPath(false, PathBase.relativize(this.segments, PathBase.toList(other), this.getPathOps().getParentToken()));
    }

    public String toString() {
        PathOps<T, P> po = this.getPathOps();
        P p = po.upcast(this);
        String result = po.toString(p);
        return result;
    }

    public static <T> List<T> relativize(List<T> a, List<T> b, T parentToken) {
        int i;
        ArrayList<T> result = new ArrayList<T>();
        int as = a.size();
        int bs = b.size();
        for (i = 0; i < as && i < bs && Objects.equals(a.get(i), b.get(i)); ++i) {
        }
        for (int j = i; j < as; ++j) {
            result.add(parentToken);
        }
        result.addAll(b.subList(i, bs));
        return result;
    }

    @Override
    public List<T> getSegments() {
        return this.segmentsView;
    }

    public P resolve(T other) {
        return this.resolve(this.getPathOps().create(other));
    }

    public P resolveSiblingStr(String other) {
        return this.resolveSibling((Path<T>)this.getPathOps().fromString(other));
    }

    public P resolveSibling(T other) {
        return this.resolveSibling((Path<T>)this.getPathOps().create(other));
    }

    public P resolveSibling(Path<T> other) {
        P parent = this.getParent();
        Path<T> result = parent == null ? other : parent.resolve(other);
        return (P)result;
    }

    @Override
    public Iterator<Path<T>> iterator() {
        return this.segmentsView.stream().map(segment -> this.getPathOps().newPath(false, Collections.singletonList(segment))).map(item -> item).iterator();
    }

    @Override
    public int compareTo(Path<T> other) {
        int result;
        if (other instanceof PathBase) {
            PathBase o = (PathBase)other;
            Comparator<T> comparator = this.getPathOps().getComparator();
            result = (o.isAbsolute ? 0 : 1) - (this.isAbsolute ? 0 : 1);
            if (result == 0) {
                result = PathBase.compareLists(this.segments, o.segments, comparator);
            }
        } else {
            result = -1;
        }
        return result;
    }

    public static <T> int compareLists(List<T> a, List<T> b, Comparator<T> comparator) {
        T bi;
        T ai;
        int result = 0;
        int as = a.size();
        int bs = b.size();
        int n = Math.min(a.size(), b.size());
        for (int i = 0; i < n && (result = comparator.compare(ai = a.get(i), bi = b.get(i))) == 0; ++i) {
        }
        result = result != 0 ? result : bs - as;
        return result;
    }

    @Override
    public Object getSystem() {
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        int cmp = this.compareTo((Path)obj);
        return cmp == 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isAbsolute ? 1231 : 1237);
        result = 31 * result + (this.pathOps == null ? 0 : this.pathOps.hashCode());
        result = 31 * result + (this.segments == null ? 0 : this.segments.hashCode());
        return result;
    }
}

