/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.path.nio;

import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Objects;
import org.aksw.commons.path.core.Path;

public class NioPath<FS extends FileSystem>
implements java.nio.file.Path {
    protected FS fileSystem;
    protected Path<String> path;

    public NioPath(FS fileSystem, Path<String> path) {
        this.path = path;
        this.fileSystem = fileSystem;
    }

    public Path<String> getBackingPath() {
        return this.path;
    }

    public FS getFileSystem() {
        return this.fileSystem;
    }

    protected NioPath<FS> newPath(Path<String> path) {
        return new NioPath<FS>(this.fileSystem, path.getRoot());
    }

    protected Path<String> extractPath(java.nio.file.Path other) {
        Path<String> result = other instanceof NioPath ? ((NioPath)other).path : null;
        return result;
    }

    @Override
    public boolean isAbsolute() {
        return this.path.isAbsolute();
    }

    @Override
    public java.nio.file.Path getRoot() {
        return this.newPath(this.path.getRoot());
    }

    @Override
    public java.nio.file.Path getFileName() {
        return this.newPath(this.path.getFileName());
    }

    @Override
    public java.nio.file.Path getParent() {
        return this.newPath(this.path.getParent());
    }

    @Override
    public int getNameCount() {
        return this.path.getNameCount();
    }

    @Override
    public java.nio.file.Path getName(int index) {
        return this.newPath(this.path.getName(index));
    }

    @Override
    public java.nio.file.Path subpath(int beginIndex, int endIndex) {
        return this.newPath(this.path.subpath(beginIndex, endIndex));
    }

    @Override
    public boolean startsWith(java.nio.file.Path other) {
        Path<String> otherPath = this.extractPath(other);
        return this.path.startsWith(otherPath);
    }

    @Override
    public boolean endsWith(java.nio.file.Path other) {
        Path<String> otherPath = this.extractPath(other);
        return this.path.endsWith(otherPath);
    }

    @Override
    public java.nio.file.Path normalize() {
        return this.newPath(this.path.normalize());
    }

    @Override
    public java.nio.file.Path resolve(java.nio.file.Path other) {
        Path<String> otherPath = this.extractPath(other);
        return this.newPath(this.path.resolve(otherPath));
    }

    @Override
    public java.nio.file.Path relativize(java.nio.file.Path other) {
        Path<String> otherPath = this.extractPath(other);
        return this.newPath(this.path.relativize(otherPath));
    }

    @Override
    public URI toUri() {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public java.nio.file.Path toAbsolutePath() {
        return this.newPath(this.path.toAbsolutePath());
    }

    @Override
    public java.nio.file.Path toRealPath(LinkOption ... options) throws IOException {
        return this;
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int compareTo(java.nio.file.Path other) {
        Path<String> otherPath = this.extractPath(other);
        return this.path.compareTo((String)((Object)otherPath));
    }

    @Override
    public String toString() {
        return Objects.toString(this.path);
    }
}

