/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.path.nio;

import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.WatchService;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.StreamSupport;
import org.aksw.commons.path.nio.PathWrapper;

public abstract class FileSystemWrapperBase
extends FileSystem {
    protected abstract FileSystem getDelegate();

    public Path wrap(Path path) {
        return new PathWrapper(path, this);
    }

    public Path unwrap(Path path) {
        return FileSystemWrapperBase.unwrap(path, false);
    }

    public static Path unwrap(Path path, boolean repeatedly) {
        Path result = path;
        while (result instanceof PathWrapper) {
            PathWrapper pw = (PathWrapper)result;
            result = pw.getDelegate();
            if (repeatedly) continue;
            break;
        }
        return result;
    }

    @Override
    public FileSystemProvider provider() {
        return this.getDelegate().provider();
    }

    @Override
    public void close() throws IOException {
        this.getDelegate().close();
    }

    @Override
    public boolean isOpen() {
        return this.getDelegate().isOpen();
    }

    @Override
    public boolean isReadOnly() {
        return this.getDelegate().isReadOnly();
    }

    @Override
    public String getSeparator() {
        return this.getDelegate().getSeparator();
    }

    @Override
    public Iterable<Path> getRootDirectories() {
        return () -> StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.getDelegate().getRootDirectories().iterator(), 0), false).map(this::wrap).iterator();
    }

    @Override
    public Iterable<FileStore> getFileStores() {
        return this.getDelegate().getFileStores();
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        return this.getDelegate().supportedFileAttributeViews();
    }

    @Override
    public Path getPath(String first, String ... more) {
        return this.wrap(this.getDelegate().getPath(first, more));
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndPattern) {
        return this.getDelegate().getPathMatcher(syntaxAndPattern);
    }

    @Override
    public UserPrincipalLookupService getUserPrincipalLookupService() {
        return this.getDelegate().getUserPrincipalLookupService();
    }

    @Override
    public WatchService newWatchService() throws IOException {
        return this.getDelegate().newWatchService();
    }
}

