/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.path.core;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.aksw.commons.path.core.Path;

public interface PathOps<T, P extends Path<T>> {
    public P upcast(Path<T> var1);

    public List<T> getBasePathSegments();

    public Comparator<T> getComparator();

    public P newPath(boolean var1, List<T> var2);

    default public P create(T arg) {
        return this.newRelativePath(arg);
    }

    public T getSelfToken();

    public T getParentToken();

    public String toString(P var1);

    default public String toStringRaw(Object path) {
        Path p = (Path)path;
        return this.toString(p);
    }

    public P fromString(String var1);

    default public P newAbsolutePath(T segment) {
        return this.newAbsolutePath(Collections.singletonList(segment));
    }

    default public P newAbsolutePath(T ... segments) {
        return this.newAbsolutePath(Arrays.asList(segments));
    }

    default public P newAbsolutePath(List<T> segments) {
        return this.newPath(true, segments);
    }

    default public P newRelativePath(T segment) {
        return this.newRelativePath(Collections.singletonList(segment));
    }

    default public P newRelativePath(T ... segments) {
        return this.newRelativePath(Arrays.asList(segments));
    }

    default public P newRelativePath(List<T> segments) {
        return this.newPath(false, segments);
    }
}

