/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.path.nio;

import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Objects;
import org.aksw.commons.path.nio.FileSystemWrapperBase;

public class PathWrapper<P extends Path, FS extends FileSystemWrapperBase>
implements Path {
    protected Path delegate;
    protected FS fileSystem;

    public PathWrapper(Path delegate, FS fileSystem) {
        this.delegate = Objects.requireNonNull(delegate);
        this.fileSystem = (FileSystemWrapperBase)Objects.requireNonNull(fileSystem);
    }

    public Path getDelegate() {
        return this.delegate;
    }

    protected P wrap(Path delegate) {
        return (P)((FileSystemWrapperBase)this.fileSystem).wrap(delegate);
    }

    protected Path unwrap(Path delegate) {
        return ((FileSystemWrapperBase)this.fileSystem).unwrap(delegate);
    }

    @Override
    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    public boolean isAbsolute() {
        return this.getDelegate().isAbsolute();
    }

    @Override
    public Path getRoot() {
        return this.wrap(this.getDelegate().getRoot());
    }

    @Override
    public Path getFileName() {
        return this.wrap(this.getDelegate().getFileName());
    }

    public P getParent() {
        return this.wrap(this.getDelegate().getParent());
    }

    @Override
    public int getNameCount() {
        return this.getDelegate().getNameCount();
    }

    public P getName(int index) {
        return this.wrap(this.getDelegate().getName(index));
    }

    public P subpath(int beginIndex, int endIndex) {
        return this.wrap(this.getDelegate().subpath(beginIndex, endIndex));
    }

    @Override
    public boolean startsWith(Path other) {
        return this.getDelegate().startsWith(this.unwrap(other));
    }

    @Override
    public boolean endsWith(Path other) {
        return this.getDelegate().endsWith(this.unwrap(other));
    }

    public P normalize() {
        return this.wrap(this.getDelegate().normalize());
    }

    public P resolve(Path other) {
        return this.wrap(this.getDelegate().resolve(this.unwrap(other)));
    }

    public P relativize(Path other) {
        return this.wrap(this.getDelegate().relativize(this.unwrap(other)));
    }

    @Override
    public URI toUri() {
        return this.getDelegate().toUri();
    }

    public P toAbsolutePath() {
        return this.wrap(this.getDelegate().toAbsolutePath());
    }

    public P toRealPath(LinkOption ... options) throws IOException {
        return this.wrap(this.getDelegate().toRealPath(options));
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        return this.getDelegate().register(watcher, events, modifiers);
    }

    @Override
    public int compareTo(Path other) {
        return this.getDelegate().compareTo(this.unwrap(other));
    }
}

