/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.path.json;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.aksw.commons.path.core.Path;
import org.aksw.commons.path.core.PathOps;
import org.aksw.commons.path.json.PathJson;

public class PathOpsJson
implements PathOps<PathJson.Step, PathJson>,
Serializable {
    private static PathOpsJson INSTANCE = null;
    protected PathJson.Step SELF_TOKEN = PathJson.Step.self();
    protected PathJson.Step PARENT_TOKEN = PathJson.Step.parent();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PathOpsJson get() {
        if (INSTANCE != null) return INSTANCE;
        Class<PathOpsJson> clazz = PathOpsJson.class;
        synchronized (PathOpsJson.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new PathOpsJson();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    @Override
    public PathJson upcast(Path<PathJson.Step> path) {
        return (PathJson)path;
    }

    @Override
    public List<PathJson.Step> getBasePathSegments() {
        return Collections.emptyList();
    }

    @Override
    public Comparator<PathJson.Step> getComparator() {
        return Comparator.naturalOrder();
    }

    @Override
    public PathJson newPath(boolean isAbsolute, List<PathJson.Step> segments) {
        return new PathJson(this, isAbsolute, segments);
    }

    @Override
    public PathJson.Step getSelfToken() {
        return this.SELF_TOKEN;
    }

    @Override
    public PathJson.Step getParentToken() {
        return this.PARENT_TOKEN;
    }

    public static JsonArray toJsonArray(Path<PathJson.Step> path) {
        JsonArray result = new JsonArray();
        for (PathJson.Step step : path.getSegments()) {
            if (step.isKey()) {
                result.add(step.getKey());
                continue;
            }
            if (!step.isIndex()) continue;
            result.add((Number)step.getIndex());
        }
        return result;
    }

    @Override
    public String toString(PathJson path) {
        JsonArray arr = PathOpsJson.toJsonArray(path);
        return (path.isAbsolute() ? "/" : "") + arr.toString();
    }

    @Override
    public String toStringRaw(Object path) {
        return this.toString((PathJson)path);
    }

    @Override
    public PathJson fromString(String rawJsonStr) {
        String jsonStr = rawJsonStr.trim();
        boolean isAbsolute = jsonStr.startsWith("/");
        if (isAbsolute) {
            jsonStr = jsonStr.substring(1);
        }
        Gson gson = new Gson();
        JsonArray arr = (JsonArray)gson.fromJson(jsonStr, JsonArray.class);
        ArrayList<PathJson.Step> steps = new ArrayList<PathJson.Step>(arr.size());
        for (JsonElement item : arr) {
            JsonPrimitive primitive = item.getAsJsonPrimitive();
            if (primitive.isString()) {
                steps.add(PathJson.Step.of(primitive.getAsString()));
                continue;
            }
            if (!primitive.isNumber()) continue;
            steps.add(PathJson.Step.of(primitive.getAsNumber().intValue()));
        }
        return new PathJson(this, isAbsolute, (List<PathJson.Step>)steps);
    }
}

