/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.path.core;

import com.google.common.base.Preconditions;
import com.google.common.collect.Streams;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.aksw.commons.path.core.Path;

public abstract class PathWrapperBase<T, F extends Path<T>>
implements Path<T> {
    protected Path<T> delegate;

    protected F wrapOrNull(Path<T> basePath) {
        F result = basePath == null ? null : (F)this.wrap(basePath);
        return result;
    }

    protected abstract F wrap(Path<T> var1);

    protected Path<T> unwrap(Path<T> wrappedPath) {
        Preconditions.checkArgument((boolean)(wrappedPath instanceof PathWrapperBase), (Object)"Argument must be derived from PathDelegateBase");
        PathWrapperBase actualPath = (PathWrapperBase)wrappedPath;
        Path<T> result = actualPath.getDelegate();
        Object pathSystem = actualPath.getSystem();
        Preconditions.checkArgument((pathSystem == this.getSystem() ? 1 : 0) != 0, (Object)"Argument must have the same system (by referential equality using ==) as this path");
        return result;
    }

    public PathWrapperBase(Path<T> delegate) {
        this.delegate = delegate;
    }

    public Path<T> getDelegate() {
        return this.delegate;
    }

    @Override
    public Iterator<Path<T>> iterator() {
        return Streams.stream(this.getDelegate().iterator()).map(this::wrap).map(p -> p).iterator();
    }

    @Override
    public int compareTo(Path<T> o) {
        return this.getDelegate().compareTo(o);
    }

    public F toAbsolutePath() {
        return this.wrapOrNull(this.getDelegate().toAbsolutePath());
    }

    @Override
    public boolean isAbsolute() {
        return this.getDelegate().isAbsolute();
    }

    @Override
    public List<T> getSegments() {
        return this.getDelegate().getSegments();
    }

    public F getRoot() {
        return this.wrapOrNull(this.getDelegate().getRoot());
    }

    public F getFileName() {
        return this.wrapOrNull(this.getDelegate().getFileName());
    }

    public F getParent() {
        return this.wrapOrNull(this.getDelegate().getParent());
    }

    @Override
    public int getNameCount() {
        return this.getDelegate().getNameCount();
    }

    public F getName(int index) {
        return this.wrapOrNull(this.getDelegate().getName(index));
    }

    public F subpath(int beginIndex, int endIndex) {
        return this.wrapOrNull(this.getDelegate().subpath(beginIndex, endIndex));
    }

    public F subpath(int beginIndex) {
        return this.wrapOrNull(this.getDelegate().subpath(beginIndex));
    }

    @Override
    public boolean startsWith(Path<T> other) {
        return this.getDelegate().startsWith(this.unwrap(other));
    }

    @Override
    public boolean endsWith(Path<T> other) {
        return this.getDelegate().endsWith(this.unwrap(other));
    }

    public F normalize() {
        return this.wrapOrNull(this.getDelegate().normalize());
    }

    public F resolveStr(String other) {
        return this.wrapOrNull(this.getDelegate().resolveStr(other));
    }

    public F resolve(T other) {
        return this.wrapOrNull(this.getDelegate().resolve(other));
    }

    public F resolve(Path<T> other) {
        return this.wrapOrNull(this.getDelegate().resolve(this.unwrap(other)));
    }

    public F resolveSiblingStr(String other) {
        return this.wrapOrNull(this.getDelegate().resolveSiblingStr(other));
    }

    public F resolveSibling(T other) {
        return this.wrapOrNull(this.getDelegate().resolveSibling(other));
    }

    public F resolveSibling(Path<T> other) {
        return this.wrapOrNull(this.getDelegate().resolveSibling(this.unwrap(other)));
    }

    public F relativize(Path<T> other) {
        return this.wrapOrNull(this.getDelegate().relativize(this.unwrap(other)));
    }

    @Override
    public Object getSystem() {
        return this.getDelegate().getSystem();
    }

    public int hashCode() {
        return Objects.hash(this.delegate);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PathWrapperBase other = (PathWrapperBase)obj;
        return Objects.equals(this.delegate, other.delegate);
    }
}

