/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.path.trav.l2;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.aksw.commons.path.core.Path;

public class Trav2Trees {

    public static abstract class TreeNode2B<T, A extends TreeNode2<T, A, B>, B extends TreeNode2<T, A, B>>
    extends TreeNode2Base<T, A, B> {
        protected A parent;
        protected Map<T, A> childMap;

        public TreeNode2B(Path<T> path, TreeNode2Provider<T, A, B> provider, A parent) {
            super(path, provider);
            this.parent = parent;
            this.childMap = new LinkedHashMap<T, A>();
        }

        @Override
        public boolean isB() {
            return true;
        }

        protected abstract A sendSelfToProvider(T var1);

        public A parent() {
            return this.parent;
        }

        public A child(T key) {
            return (A)((TreeNode2)this.childMap.get(key));
        }

        @Override
        protected Map<T, ?> getChildMap() {
            return this.childMap;
        }

        @Override
        public TreeNode<T> traverse(T key) {
            TreeNode2 result = this.childMap.computeIfAbsent(key, this::sendSelfToProvider);
            return result;
        }

        @Override
        public <X> X accept(TreeNode2Visitor<X, A, B> visitor) {
            Object a = this.asB();
            X result = visitor.visitB(a);
            return result;
        }
    }

    public static abstract class TreeNode2A<T, A extends TreeNode2<T, A, B>, B extends TreeNode2<T, A, B>>
    extends TreeNode2Base<T, A, B> {
        protected B parent;
        protected Map<T, B> childMap;

        public TreeNode2A(Path<T> path, TreeNode2Provider<T, A, B> provider, B parent) {
            super(path, provider);
            this.parent = parent;
            this.childMap = new LinkedHashMap<T, B>();
        }

        @Override
        public boolean isA() {
            return true;
        }

        protected abstract B sendSelfToProvider(T var1);

        public B parent() {
            return this.parent;
        }

        public B child(T key) {
            return (B)((TreeNode2)this.childMap.get(key));
        }

        @Override
        protected Map<T, ?> getChildMap() {
            return this.childMap;
        }

        @Override
        public TreeNode<T> traverse(T key) {
            TreeNode2 b = this.childMap.computeIfAbsent(key, this::sendSelfToProvider);
            return b;
        }

        @Override
        public <X> X accept(TreeNode2Visitor<X, A, B> visitor) {
            Object a = this.asA();
            X result = visitor.visitA(a);
            return result;
        }
    }

    public static abstract class TreeNode2Base<T, A extends TreeNode2<T, A, B>, B extends TreeNode2<T, A, B>>
    implements TreeNode2<T, A, B> {
        protected Path<T> path;
        protected TreeNode2Provider<T, A, B> provider;

        public TreeNode2Base(Path<T> path, TreeNode2Provider<T, A, B> provider) {
            this.path = path;
            this.provider = provider;
        }

        protected abstract Map<T, ?> getChildMap();

        @Override
        public Path<T> path() {
            return this.path;
        }

        @Override
        public Stream<T> childKeys() {
            return this.getChildMap().keySet().stream();
        }
    }

    public static abstract class TreeNode2ProviderBase<T, A extends TreeNode2<T, A, B>, B extends TreeNode2<T, A, B>>
    implements TreeNode2Provider<T, A, B> {
        protected A root = null;

        @Override
        public A root() {
            if (this.root == null) {
                this.root = this.mkRoot();
            }
            return this.root;
        }
    }

    public static interface TreeNode2Provider<T, A extends TreeNode2<T, A, B>, B extends TreeNode2<T, A, B>> {
        public A mkRoot();

        public B toB(A var1, T var2);

        public A toA(B var1, T var2);

        public A root();

        default public TreeNode2<T, A, B> resolve(Path<T> path) {
            Object result = this.root();
            List<T> segments = path.getSegments();
            for (T segment : segments) {
                result = result.traverse(segment);
            }
            return (TreeNode2)result;
        }
    }

    public static interface TreeNode2<T, A extends TreeNode2<T, A, B>, B extends TreeNode2<T, A, B>>
    extends TreeNode<T> {
        default public boolean isA() {
            return false;
        }

        default public boolean isB() {
            return false;
        }

        default public A asA() {
            return (A)this;
        }

        default public B asB() {
            return (B)this;
        }

        public <X> X accept(TreeNode2Visitor<X, A, B> var1);
    }

    public static interface TreeNode<T> {
        public Path<T> path();

        public TreeNode<T> parent();

        public Stream<T> childKeys();

        public TreeNode<T> child(T var1);

        public TreeNode<T> traverse(T var1);
    }

    public static interface TreeNode2Visitor<X, A, B> {
        public X visitA(A var1);

        public X visitB(B var1);
    }
}

