/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.path.nio;

import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.aksw.commons.path.core.PathSys;
import org.aksw.commons.path.nio.FileSystem2;
import org.aksw.commons.path.nio.FileSystemWithSpec;
import org.aksw.commons.path.nio.FileSystemWrapper;

public class FileSystemSpec {
    protected Map<String, ?> env;
    protected ClassLoader loader;
    protected URI uri;
    protected PathSys<String, FileSystemSpec> basePath;

    protected FileSystemSpec(Map<String, ?> env, ClassLoader loader, PathSys<String, FileSystemSpec> basePath) {
        this.env = env;
        this.loader = loader;
        this.basePath = Objects.requireNonNull(basePath);
    }

    protected FileSystemSpec(Map<String, ?> env, ClassLoader loader, URI uri) {
        this.env = env;
        this.loader = loader;
        this.uri = Objects.requireNonNull(uri);
    }

    public static FileSystemSpec of(Map<String, ?> env, ClassLoader loader, URI uri) {
        return new FileSystemSpec(env, loader, uri);
    }

    public static FileSystemSpec of(Map<String, ?> env, ClassLoader loader, PathSys<String, FileSystemSpec> basePath) {
        return new FileSystemSpec(env, loader, basePath);
    }

    public boolean isUri() {
        return this.uri != null;
    }

    public boolean isPath() {
        return this.basePath != null;
    }

    public FileSystem resolve() throws IOException {
        FileSystemWrapper result;
        if (this.isUri()) {
            result = new FileSystemWithSpec(FileSystems.newFileSystem(this.uri, this.env, this.loader), this);
        } else {
            FileSystemSpec baseSpec = this.basePath.getSystem();
            FileSystem baseFs = baseSpec.resolve();
            List segments = this.basePath.getSegments();
            String first = segments.isEmpty() ? "" : (String)segments.get(0);
            String[] rest = segments.isEmpty() ? new String[]{} : segments.subList(1, segments.size()).toArray(new String[0]);
            Path path = baseFs.getPath(first, rest);
            FileSystemWithSpec outer = new FileSystemWithSpec(FileSystems.newFileSystem(path, this.env, this.loader), this);
            result = new FileSystem2(outer, baseFs);
        }
        return result;
    }
}

