/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.store.object.key.impl;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.pool.KryoFactory;
import com.esotericsoftware.kryo.pool.KryoPool;
import com.esotericsoftware.kryo.serializers.JavaSerializer;
import com.google.common.collect.Range;
import com.google.common.collect.TreeRangeMap;
import com.google.common.collect.TreeRangeSet;
import java.util.AbstractMap;
import java.util.function.Consumer;
import org.aksw.commons.kryo.guava.EntrySerializer;
import org.aksw.commons.kryo.guava.RangeMapSerializer;
import org.aksw.commons.kryo.guava.RangeSetSerializer;

public class KryoUtils {
    public static KryoPool createKryoPool(final Consumer<Kryo> customRegistrator) {
        KryoFactory factory = new KryoFactory(){

            public Kryo create() {
                Kryo kryo = new Kryo();
                JavaSerializer javaSerializer = new JavaSerializer();
                RangeSetSerializer rangeSetSerializer = new RangeSetSerializer();
                RangeMapSerializer rangeMapSerializer = new RangeMapSerializer();
                EntrySerializer entrySerializer = new EntrySerializer();
                kryo.register(TreeRangeSet.class, (Serializer)rangeSetSerializer);
                kryo.register(TreeRangeMap.class, (Serializer)rangeMapSerializer);
                kryo.register(Range.class, (Serializer)javaSerializer);
                kryo.register(AbstractMap.SimpleEntry.class, (Serializer)entrySerializer);
                if (customRegistrator != null) {
                    customRegistrator.accept(kryo);
                }
                return kryo;
            }
        };
        KryoPool result = new KryoPool.Builder(factory).softReferences().build();
        return result;
    }
}

