/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.store.object.path.impl;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.pool.KryoPool;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.aksw.commons.store.object.path.api.ObjectSerializer;

public class ObjectSerializerKryo
implements ObjectSerializer {
    protected KryoPool kryoPool;

    protected ObjectSerializerKryo(KryoPool kryoPool) {
        this.kryoPool = kryoPool;
    }

    public static ObjectSerializerKryo create(KryoPool kryoPool) {
        return new ObjectSerializerKryo(kryoPool);
    }

    @Override
    public void write(OutputStream out, Object obj) throws IOException {
        Kryo kryo = this.kryoPool.borrow();
        Output o = new Output(out);
        kryo.writeClassAndObject(o, obj);
        o.flush();
        this.kryoPool.release(kryo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object read(InputStream in) throws IOException {
        Kryo kryo = this.kryoPool.borrow();
        try {
            Object object = kryo.readClassAndObject(new Input(in));
            return object;
        }
        finally {
            this.kryoPool.release(kryo);
        }
    }
}

