/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.store.object.path.impl;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.pool.KryoPool;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.aksw.commons.store.object.path.api.ObjectFileStore;

public class ObjectFileStoreKryo
implements ObjectFileStore {
    protected KryoPool kryoPool;

    public ObjectFileStoreKryo(KryoPool kryoPool) {
        this.kryoPool = kryoPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Path target, Object obj) throws IOException {
        Kryo kryo = this.kryoPool.borrow();
        try (Output out = new Output(Files.newOutputStream(target, StandardOpenOption.WRITE, StandardOpenOption.CREATE));){
            kryo.writeClassAndObject(out, obj);
            out.flush();
        }
        finally {
            this.kryoPool.release(kryo);
        }
    }

    @Override
    public Object read(Path source) throws IOException, ClassNotFoundException {
        Kryo kryo = this.kryoPool.borrow();
        try {
            Object object;
            block9: {
                InputStream in = Files.newInputStream(source, StandardOpenOption.READ);
                try {
                    object = kryo.readClassAndObject(new Input(in));
                    if (in == null) break block9;
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                in.close();
            }
            return object;
        }
        finally {
            this.kryoPool.release(kryo);
        }
    }
}

