/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.store.object.key.impl;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalCause;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Objects;
import org.aksw.commons.cache.async.AsyncClaimingCache;
import org.aksw.commons.cache.async.AsyncClaimingCacheImpl;
import org.aksw.commons.io.util.PathUtils;
import org.aksw.commons.path.core.Path;
import org.aksw.commons.store.object.key.api.ObjectResource;
import org.aksw.commons.store.object.key.api.ObjectStore;
import org.aksw.commons.store.object.key.api.ObjectStoreConnection;
import org.aksw.commons.store.object.key.impl.ObjectInfo;
import org.aksw.commons.store.object.path.api.ObjectSerializer;
import org.aksw.commons.txn.api.Txn;
import org.aksw.commons.txn.api.TxnMgr;
import org.aksw.commons.txn.api.TxnResourceApi;
import org.aksw.commons.txn.impl.FileSync;
import org.aksw.commons.txn.impl.FileSyncImpl;
import org.aksw.commons.txn.impl.PathDiffState;
import org.aksw.commons.txn.impl.TxnHandler;
import org.aksw.commons.txn.impl.TxnHandlerImpl;
import org.aksw.commons.txn.impl.TxnMgrImpl;
import org.aksw.commons.txn.impl.TxnUtils;
import org.aksw.commons.util.ref.RefFuture;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ObjectStoreImpl
implements ObjectStore {
    protected TxnMgr txnMgr;
    protected TxnHandlerImpl txnHandler;
    protected ObjectSerializer objectSerializer;
    protected AsyncClaimingCache<Path<String>, ObjectInfo> contentCache;
    protected AsyncClaimingCache<Path<String>, ObjectResource> accessorCache;

    public ObjectStoreImpl(TxnMgr txnMgr, TxnHandlerImpl txnHandler, ObjectSerializer objectSerializer, AsyncClaimingCache<Path<String>, ObjectInfo> contentCache, AsyncClaimingCache<Path<String>, ObjectResource> accessorCache) {
        this.txnMgr = txnMgr;
        this.txnHandler = txnHandler;
        this.objectSerializer = objectSerializer;
        this.contentCache = contentCache;
        this.accessorCache = accessorCache;
    }

    @Override
    public PathDiffState fetchRecencyStatus(Path<String> key) {
        java.nio.file.Path path = PathUtils.resolve((java.nio.file.Path)this.txnMgr.getRootPath().resolve(this.txnMgr.getResRepo().getRootPath()), (Iterable)key.getSegments());
        FileSyncImpl fileSync = FileSyncImpl.create((java.nio.file.Path)path, (boolean)false);
        PathDiffState result = FileSyncImpl.getState((FileSync)fileSync);
        return result;
    }

    public static ObjectStore create(java.nio.file.Path rootPath, ObjectSerializer objectSerializer) {
        TxnMgrImpl txnMgr = TxnMgrImpl.createSimple((java.nio.file.Path)rootPath);
        TxnHandlerImpl txnHandler = new TxnHandlerImpl((TxnMgr)txnMgr);
        try {
            txnHandler.cleanupStaleTxns();
        }
        catch (IOException e1) {
            throw new RuntimeException(e1);
        }
        AsyncClaimingCacheImpl contentCache = AsyncClaimingCacheImpl.newBuilder((Caffeine)Caffeine.newBuilder()).setCacheLoader((CacheLoader)new CacheLoader<Path<String>, ObjectInfo>(){
            final /* synthetic */ TxnMgr val$txnMgr;
            final /* synthetic */ ObjectSerializer val$objectSerializer;
            final /* synthetic */ TxnHandlerImpl val$txnHandler;
            {
                this.val$txnMgr = txnMgr;
                this.val$objectSerializer = objectSerializer;
                this.val$txnHandler = txnHandlerImpl;
            }

            public @Nullable ObjectInfo load(Path<String> key) throws Exception {
                Object obj;
                Txn txn = this.val$txnMgr.newTxn(true, false);
                TxnResourceApi api = txn.getResourceApi(key);
                api.declareAccess();
                api.lock(false);
                java.nio.file.Path path = api.getFileSync().getCurrentPath();
                PathDiffState status = FileSyncImpl.getState((FileSync)api.getFileSync());
                if (status.getCurrentState().getTimestamp() == null) {
                    obj = null;
                } else {
                    try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
                        obj = this.val$objectSerializer.read(in);
                    }
                }
                this.val$txnHandler.commit(txn);
                return new ObjectInfo(obj, Objects.hashCode(obj), status);
            }

            public @Nullable ObjectInfo reload(Path<String> key, ObjectInfo oldValue) throws Exception {
                return (ObjectInfo)super.reload(key, (Object)oldValue);
            }
        }).setEvictionListener((arg_0, arg_1, arg_2) -> ObjectStoreImpl.lambda$create$0((TxnMgr)txnMgr, objectSerializer, txnHandler, arg_0, arg_1, arg_2)).build();
        return new ObjectStoreImpl((TxnMgr)txnMgr, txnHandler, objectSerializer, (AsyncClaimingCache<Path<String>, ObjectInfo>)contentCache, null);
    }

    protected static void save(TxnMgr txnMgr, ObjectSerializer objectSerializer, TxnHandlerImpl txnHandler, Path<String> key, ObjectInfo v) throws IOException {
        Txn txn = txnMgr.newTxn(true, true);
        TxnResourceApi api = txn.getResourceApi(key);
        api.declareAccess();
        api.lock(true);
        api.getFileSync().putContent(out -> {
            try {
                objectSerializer.write((OutputStream)v.getObject(), out);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        txnHandler.commit(txn);
    }

    @Override
    public RefFuture<ObjectInfo> claim(Path<String> key) {
        return this.contentCache.claim(key);
    }

    @Override
    public ObjectStoreConnection getConnection() {
        return new ObjectStoreConnectionImpl();
    }

    @Override
    public void close() throws Exception {
    }

    private static /* synthetic */ void lambda$create$0(TxnMgr txnMgr, ObjectSerializer objectSerializer, TxnHandlerImpl txnHandler, Path k, ObjectInfo v, RemovalCause c) {
        try {
            ObjectStoreImpl.save(txnMgr, objectSerializer, txnHandler, (Path<String>)k, v);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    class ObjectStoreConnectionImpl
    implements ObjectStoreConnection {
        protected Txn txn = null;

        ObjectStoreConnectionImpl() {
        }

        public void begin(boolean write) {
            if (this.txn != null) {
                throw new RuntimeException("Already in a txn");
            }
            try {
                this.txn = ObjectStoreImpl.this.txnMgr.newTxn(true, write);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public void commit() {
            Objects.requireNonNull(this.txn, "Cannot commit because there is no active transaction; Perhaps missing call to .begin()?");
            ObjectStoreImpl.this.txnHandler.commit(this.txn);
            this.txn = null;
        }

        @Override
        public void commit(TxnHandler customHandler) {
            Objects.requireNonNull(this.txn, "Cannot commit because there is no active transaction; Perhaps missing call to .begin()?");
            TxnUtils.commit((Txn)this.txn, (TxnHandler)customHandler);
            this.txn = null;
        }

        public void abort() {
            Objects.requireNonNull(this.txn, "Cannot abort because there is no active transaction; Perhaps missing call to .begin()?");
            ObjectStoreImpl.this.txnHandler.abort(this.txn);
            this.txn = null;
        }

        @Override
        public ObjectResource access(Path<String> keySegments) {
            TxnResourceApi api = this.txn.getResourceApi(keySegments);
            api.declareAccess();
            api.lock(this.txn.isWrite());
            return new ObjectResourceImpl(api);
        }

        @Override
        public void close() throws Exception {
            if (this.txn != null) {
                ObjectStoreImpl.this.txnHandler.rollbackOrEnd(this.txn);
                this.txn = null;
            }
        }

        class ObjectResourceImpl
        implements ObjectResource {
            protected TxnResourceApi res;

            public ObjectResourceImpl(TxnResourceApi res) {
                this.res = res;
            }

            @Override
            public void close() throws Exception {
            }

            @Override
            public PathDiffState fetchRecencyStatus() {
                PathDiffState status = FileSyncImpl.getState((FileSync)this.res.getFileSync());
                return status;
            }

            @Override
            public Object loadNewInstance() {
                Object result = null;
                if (this.res.getFileSync().exists()) {
                    try (InputStream in = this.res.getFileSync().openCurrentContent();){
                        result = ObjectStoreImpl.this.objectSerializer.read(in);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                return result;
            }

            @Override
            public void save(Object obj) {
                try {
                    this.res.getFileSync().putContent(out -> {
                        try {
                            ObjectStoreImpl.this.objectSerializer.write((OutputStream)out, obj);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    });
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

