/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.model.maven.domain.api;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.aksw.commons.model.maven.domain.impl.MavenEntityCoreImpl;

public interface MavenEntityCore {
    public static final String URN_MVN = "urn:mvn:";

    public String getGroupId();

    public MavenEntityCore setGroupId(String var1);

    public String getArtifactId();

    public MavenEntityCore setArtifactId(String var1);

    public String getVersion();

    public MavenEntityCore setVersion(String var1);

    public String getType();

    public MavenEntityCore setType(String var1);

    public String getClassifier();

    public MavenEntityCore setClassifier(String var1);

    public String getRemainder();

    public MavenEntityCore setRemainder(String var1);

    public static MavenEntityCore normalize(MavenEntityCore coord) {
        String g = Objects.toString(coord.getGroupId(), "").trim();
        String a = Objects.toString(coord.getArtifactId(), "").trim();
        String v = Objects.toString(coord.getVersion(), "").trim();
        String c = Objects.toString(coord.getClassifier(), "").trim();
        String t = Objects.toString(coord.getType(), "").trim();
        String r = Objects.toString(coord.getRemainder(), "").trim();
        if (!c.isEmpty() && t.isEmpty()) {
            t = "jar";
        }
        return new MavenEntityCoreImpl(g, a, v, t, c, r);
    }

    public static String toString(MavenEntityCore coord) {
        String t = coord.getType();
        String c = coord.getClassifier();
        String r = coord.getRemainder();
        String suffix = (String)(t == null || t.isEmpty() ? "" : ":" + t) + (String)(c == null || c.isEmpty() ? "" : ":" + c) + (r == null || r.isEmpty() ? "" : r);
        String result = coord.getGroupId() + ":" + coord.getArtifactId() + ":" + coord.getVersion() + suffix;
        return result;
    }

    public static String getFileNameSuffix(MavenEntityCore coord) {
        String t = coord.getType();
        String c = coord.getClassifier();
        String result = (String)(c == null || c.isEmpty() ? "" : "-" + c) + (String)(t == null || t.isEmpty() ? "" : "." + t);
        return result;
    }

    public static String toRelativeUrl(MavenEntityCore coord) {
        String result = MavenEntityCore.toPath(coord) + "/" + MavenEntityCore.toFileName(coord);
        return result;
    }

    public static String toFileName(MavenEntityCore coord) {
        String suffix = MavenEntityCore.getFileNameSuffix(coord);
        String v = coord.getVersion();
        String result = coord.getArtifactId() + (String)(v == null || v.isEmpty() ? "" : "-" + v) + suffix;
        return result;
    }

    public static String toPath(MavenEntityCore coord) {
        String[] gs = coord.getGroupId().split("\\.");
        String g = Arrays.asList(gs).stream().map(String::trim).filter(x -> !x.isEmpty()).collect(Collectors.joining("/"));
        String result = Arrays.asList(g, coord.getArtifactId(), coord.getVersion()).stream().filter(x -> x != null && !x.isEmpty()).collect(Collectors.joining("/"));
        return result;
    }

    public static MavenEntityCore parseId(String mvnIdEx) {
        int remainderOffset = -1;
        for (int i = 0; i < mvnIdEx.length(); ++i) {
            char c = mvnIdEx.charAt(i);
            if (c != '/' && c != '#' && c != '!') continue;
            remainderOffset = i;
            break;
        }
        String mvnId = remainderOffset == -1 ? mvnIdEx : mvnIdEx.substring(0, remainderOffset);
        String remainder = remainderOffset == -1 ? null : mvnIdEx.substring(remainderOffset);
        String[] tmp = mvnId.split(":", 5);
        String[] parts = new String[5];
        System.arraycopy(tmp, 0, parts, 0, tmp.length);
        return new MavenEntityCoreImpl(parts[0], parts[1], parts[2], parts[3], parts[4], remainder);
    }

    public static MavenEntityCore parseUrn(String mvnUrn) {
        if (!mvnUrn.startsWith(URN_MVN)) {
            throw new IllegalArgumentException("Argument does not start with urn:mvn: - got: " + mvnUrn);
        }
        String arg = mvnUrn.substring(URN_MVN.length());
        MavenEntityCore result = MavenEntityCore.parseId(arg);
        return result;
    }

    public static MavenEntityCore parse(String mvnIdOrUrn) {
        String arg = mvnIdOrUrn.startsWith(URN_MVN) ? mvnIdOrUrn.substring(URN_MVN.length()) : mvnIdOrUrn;
        return MavenEntityCore.parseId(arg);
    }

    public static String toPath(MavenEntityCore entity, String snapshotPrefix, String internalPrefix, String componentSeparator, boolean includePrefix, boolean includeDirectories, boolean includeFileName) {
        String prefix;
        Object result = null;
        boolean isSnapshot = Optional.ofNullable(entity.getVersion()).map(String::toUpperCase).map(str -> str.endsWith("-SNAPSHOT")).orElse(false);
        String string = includePrefix ? (isSnapshot ? snapshotPrefix : internalPrefix) : (prefix = null);
        if (prefix != null && prefix.isEmpty()) {
            prefix = null;
        }
        String pathStr = includeDirectories ? MavenEntityCore.toPath(entity) : null;
        String fileName = includeFileName ? MavenEntityCore.toFileName(entity) : null;
        String remainder = entity.getRemainder();
        result = Arrays.asList(prefix, pathStr, fileName).stream().filter(Objects::nonNull).collect(Collectors.joining(componentSeparator));
        if (remainder != null) {
            result = (String)result + remainder;
        }
        return result;
    }
}

