/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.model.csvw.univocity;

import com.univocity.parsers.common.AbstractParser;
import com.univocity.parsers.common.CommonParserSettings;
import com.univocity.parsers.csv.CsvFormat;
import com.univocity.parsers.csv.CsvParser;
import com.univocity.parsers.csv.CsvParserSettings;
import com.univocity.parsers.tsv.TsvParser;
import com.univocity.parsers.tsv.TsvParserSettings;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.aksw.commons.model.csvw.domain.api.Dialect;
import org.aksw.commons.model.csvw.domain.api.DialectMutable;
import org.aksw.commons.model.csvw.domain.impl.CsvwLib;
import org.aksw.commons.model.csvw.univocity.CsvwUnivocityUtils;
import org.aksw.commons.model.csvw.univocity.UnivocityCsvwConf;

public class UnivocityParserFactory {
    protected boolean isCsv;
    protected CsvParserSettings csvSettings;
    protected TsvParserSettings tsvSettings;
    protected Charset charset;

    public UnivocityParserFactory(boolean isCsv, Charset charset, CsvParserSettings csvSettings, TsvParserSettings tsvSettings) {
        this.isCsv = isCsv;
        this.charset = charset;
        this.csvSettings = csvSettings;
        this.tsvSettings = tsvSettings;
    }

    public CsvParserSettings getCsvSettings() {
        return this.csvSettings;
    }

    public TsvParserSettings getTsvSettings() {
        return this.tsvSettings;
    }

    public static UnivocityParserFactory createDefault(Boolean skipHeaders) {
        CsvParserSettings defaultCsvSettings = new CsvParserSettings();
        defaultCsvSettings.setEmptyValue("");
        UnivocityParserFactory.applyDefaults(defaultCsvSettings, skipHeaders);
        TsvParserSettings defaultTsvSettings = new TsvParserSettings();
        UnivocityParserFactory.applyDefaults(defaultTsvSettings, skipHeaders);
        return new UnivocityParserFactory(true, StandardCharsets.UTF_8, defaultCsvSettings, defaultTsvSettings);
    }

    public static void applyDefaults(CommonParserSettings<?> settings, Boolean skipHeaders) {
        settings.setMaxCharsPerColumn(-1);
        settings.setAutoClosingEnabled(false);
        settings.setLineSeparatorDetectionEnabled(false);
        settings.trimValues(false);
        settings.setHeaderExtractionEnabled(!Boolean.FALSE.equals(skipHeaders));
        settings.setReadInputOnSeparateThread(false);
    }

    public UnivocityParserFactory configure(UnivocityCsvwConf conf) {
        UnivocityParserFactory result;
        DialectMutable dialect = conf.getDialect();
        Charset cs = CsvwLib.getEncoding((Dialect)dialect, (Charset)this.charset);
        if (conf.isTabs()) {
            TsvParserSettings settings = this.tsvSettings.clone();
            CsvwUnivocityUtils.configureCommonSettings(settings, conf);
            result = new UnivocityParserFactory(false, cs, this.csvSettings, settings);
        } else {
            CsvParserSettings settings = this.csvSettings.clone();
            CsvwUnivocityUtils.configureCsvFormat((CsvFormat)settings.getFormat(), (Dialect)dialect);
            CsvwUnivocityUtils.configureCommonSettings(settings, conf);
            CsvwUnivocityUtils.configureDetection(settings, (Dialect)dialect);
            result = new UnivocityParserFactory(true, cs, settings, this.tsvSettings);
        }
        return result;
    }

    public InputStreamReader newInputStreamReader(InputStream in) {
        return new InputStreamReader(in, this.charset);
    }

    public AbstractParser<?> newParser() {
        CsvParser result = this.isCsv ? new CsvParser(this.csvSettings) : new TsvParser(this.tsvSettings);
        return result;
    }
}

