/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.model.csvw.univocity;

import com.univocity.parsers.common.AbstractParser;
import com.univocity.parsers.common.CommonParserSettings;
import com.univocity.parsers.common.record.Record;
import com.univocity.parsers.csv.CsvFormat;
import com.univocity.parsers.csv.CsvParser;
import com.univocity.parsers.csv.CsvParserSettings;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.aksw.commons.collections.utils.StreamUtils;
import org.aksw.commons.lambda.throwing.ThrowingBiConsumer;
import org.aksw.commons.lambda.throwing.ThrowingFunction;
import org.aksw.commons.model.csvw.univocity.UnivocityParserFactory;

public class UnivocityUtils {
    public static boolean isDetectionNeeded(CsvParserSettings settings) {
        boolean result = settings.isLineSeparatorDetectionEnabled() || settings.isDelimiterDetectionEnabled() || settings.isQuoteDetectionEnabled();
        return result;
    }

    public static boolean isDetectionNeeded(CommonParserSettings<?> settings) {
        boolean result = settings.isLineSeparatorDetectionEnabled();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CsvFormat detectFormat(CsvParser parser, Supplier<Reader> readerSupp) throws IOException {
        CsvFormat result;
        try (Reader reader = readerSupp.get();){
            parser.beginParsing(reader);
            result = parser.getDetectedFormat();
        }
        finally {
            parser.stopParsing();
        }
        return result;
    }

    public static Stream<Record> readCsvRecords(Callable<? extends InputStream> inputStreamFactory, UnivocityParserFactory parserFactory) {
        return UnivocityUtils.readCsvElements(inputStreamFactory, parserFactory, AbstractParser::parseNextRecord);
    }

    public static Stream<String[]> readCsvRows(Callable<? extends InputStream> inputStreamFactory, UnivocityParserFactory parserFactory) {
        return UnivocityUtils.readCsvElements(inputStreamFactory, parserFactory, AbstractParser::parseNext);
    }

    public static <T> Stream<T> readCsvElements(Callable<? extends InputStream> inSupp, UnivocityParserFactory parserFactory, Function<AbstractParser<?>, T> extractElement) {
        return StreamUtils.fromEnumerableResource(() -> parserFactory.newInputStreamReader((InputStream)inSupp.call()), (ThrowingFunction & Serializable)reader -> {
            AbstractParser<?> r = parserFactory.newParser();
            r.beginParsing((Reader)reader);
            return r;
        }, (ThrowingFunction & Serializable)csvParser -> extractElement.apply((AbstractParser<?>)csvParser), (record, parser) -> record == null, (ThrowingBiConsumer & Serializable)(in, csvParser) -> csvParser.stopParsing());
    }
}

