/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.model.csvw.univocity;

import com.univocity.parsers.common.CommonParserSettings;
import com.univocity.parsers.common.Context;
import com.univocity.parsers.common.processor.core.Processor;
import com.univocity.parsers.conversions.Conversions;
import com.univocity.parsers.conversions.NullStringConversion;
import com.univocity.parsers.csv.CsvFormat;
import com.univocity.parsers.csv.CsvParser;
import com.univocity.parsers.csv.CsvParserSettings;
import java.io.Reader;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import org.aksw.commons.model.csvw.domain.api.Dialect;
import org.aksw.commons.model.csvw.domain.api.DialectMutable;
import org.aksw.commons.model.csvw.domain.impl.CsvwLib;
import org.aksw.commons.model.csvw.univocity.UnivocityCsvwConf;

public class CsvwUnivocityUtils {
    public static Set<String> configureCommonSettings(CommonParserSettings<?> settings, UnivocityCsvwConf csvwConf) {
        Long l;
        String str;
        LinkedHashSet<String> affectedTerms = new LinkedHashSet<String>();
        DialectMutable dialect = csvwConf.getDialect();
        Boolean b = dialect.getSkipBlankRows();
        if (b != null) {
            settings.setSkipEmptyLines(b.booleanValue());
            affectedTerms.add("http://www.w3.org/ns/csvw#skipBlankRows");
        }
        if ((str = dialect.getTrim()) != null && !str.isBlank()) {
            settings.trimValues(true);
            affectedTerms.add("http://www.w3.org/ns/csvw#trim");
        }
        if ((l = dialect.getHeaderRowCount()) != null) {
            if (l > 1L) {
                throw new IllegalArgumentException("Only at most one header row presently supported");
            }
            settings.setHeaderExtractionEnabled(l > 0L);
            affectedTerms.add("http://www.w3.org/ns/csvw#headerRowCount");
        }
        if (csvwConf.getNullValues() != null && csvwConf.getNullValues().length > 0) {
            final NullStringConversion nullStringConversion = Conversions.toNull((String[])csvwConf.getNullValues());
            settings.setProcessor((Processor)new Processor<Context>(){

                public void processStarted(Context context) {
                }

                public void rowProcessed(String[] row, Context context) {
                    for (int i = 0; i < row.length; ++i) {
                        row[i] = (String)nullStringConversion.execute((Object)row[i]);
                    }
                }

                public void processEnded(Context context) {
                }
            });
        }
        return affectedTerms;
    }

    public static Set<String> configureDetection(CsvParserSettings settings, Dialect dialect) {
        HashSet<String> affectedTerms = new HashSet<String>();
        if (dialect.getLineTerminators() == null) {
            settings.setLineSeparatorDetectionEnabled(true);
            affectedTerms.add("http://www.w3.org/ns/csvw#lineTerminators");
        }
        if (dialect.getDelimiter() == null) {
            settings.setDelimiterDetectionEnabled(true);
            affectedTerms.add("http://www.w3.org/ns/csvw#delimiter");
        }
        if (dialect.getQuoteChar() == null) {
            settings.setQuoteDetectionEnabled(true);
            affectedTerms.add("http://www.w3.org/ns/csvw#quoteChar");
        }
        return affectedTerms;
    }

    public static Set<String> configureCsvFormat(CsvFormat format, Dialect dialect) {
        HashSet<String> affectedTerms = new HashSet<String>();
        String str = dialect.getQuoteChar();
        if (CsvwLib.isPresent((String)str)) {
            format.setQuote(CsvwLib.expectAtMostOneChar((String)"quoteChar", (String)str).charValue());
            affectedTerms.add("http://www.w3.org/ns/csvw#quoteChar");
        }
        if (CsvwLib.isPresent((String)(str = dialect.getDelimiter()))) {
            format.setDelimiter(str);
            affectedTerms.add("http://www.w3.org/ns/csvw#delimiter");
        }
        if (CsvwLib.isPresent((String)(str = dialect.getCommentPrefix()))) {
            format.setComment(CsvwLib.expectAtMostOneChar((String)"commentChar", (String)str).charValue());
            affectedTerms.add("http://www.w3.org/ns/csvw#commentPrefix");
        }
        if (CsvwLib.isPresent((String)(str = dialect.getLineTerminators()))) {
            format.setLineSeparator(str);
            affectedTerms.add("http://www.w3.org/ns/csvw#lineTerminators");
        }
        if (CsvwLib.isPresent((String)(str = dialect.getQuoteEscapeChar()))) {
            format.setQuoteEscape(CsvwLib.expectAtMostOneChar((String)"quoteEscapeChar", (String)str).charValue());
            affectedTerms.add("http://www.w3.org/ns/csvw#quoteChar");
        }
        return affectedTerms;
    }

    public static Set<String> configureDialect(DialectMutable dialect, CsvFormat format) {
        LinkedHashSet<String> affectedTerms = new LinkedHashSet<String>();
        String str = format.getDelimiterString();
        if (str != null && !Objects.equals(str, dialect.getDelimiter())) {
            dialect.setDelimiter(str);
            affectedTerms.add("http://www.w3.org/ns/csvw#delimiter");
        }
        if ((str = format.getLineSeparatorString()) != null && !Objects.equals(str, dialect.getLineTerminators())) {
            dialect.setLineTerminators(str);
            affectedTerms.add("http://www.w3.org/ns/csvw#lineTerminators");
        }
        if (!Objects.equals(str = Character.toString(format.getQuote()), dialect.getQuoteChar())) {
            dialect.setQuoteChar(str);
            affectedTerms.add("http://www.w3.org/ns/csvw#quoteChar");
        }
        if (!Objects.equals(str = Character.toString(format.getQuoteEscape()), dialect.getQuoteEscapeChar())) {
            dialect.setQuoteEscapeChar(str);
            affectedTerms.add("http://www.w3.org/ns/csvw#quoteEscapeChar");
        }
        return affectedTerms;
    }

    public static boolean isDetectionNeeded(CsvParserSettings settings) {
        boolean result = settings.isLineSeparatorDetectionEnabled() || settings.isDelimiterDetectionEnabled() || settings.isQuoteDetectionEnabled();
        return result;
    }

    public static boolean isDetectionNeeded(CommonParserSettings<?> settings) {
        boolean result = settings.isLineSeparatorDetectionEnabled();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CsvFormat detectFormat(CsvParser parser, Callable<Reader> readerSupp) throws Exception {
        CsvFormat result;
        try (Reader reader = readerSupp.call();){
            parser.beginParsing(reader);
            result = parser.getDetectedFormat();
        }
        finally {
            parser.stopParsing();
        }
        return result;
    }

    public static Set<String> configureDialect(DialectMutable dialect, CsvParserSettings settings, Callable<CsvParser> parserFactory, Callable<Reader> readerSupp) throws Exception {
        Set<String> result = Collections.emptySet();
        if (CsvwUnivocityUtils.isDetectionNeeded(settings)) {
            CsvParser parser = parserFactory.call();
            CsvFormat format = CsvwUnivocityUtils.detectFormat(parser, readerSupp);
            result = CsvwUnivocityUtils.configureDialect(dialect, format);
        }
        return result;
    }
}

