/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.model.csvw.domain.api;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import org.aksw.commons.model.csvw.domain.api.DialectMutable;
import org.aksw.commons.model.csvw.domain.api.GsonUtils;

public interface Dialect {
    public String getCommentPrefix();

    public String getDelimiter();

    public Boolean isDoubleQuote();

    public String getEncoding();

    public Boolean getHeader();

    public Long getHeaderRowCount();

    public String getLineTerminators();

    public String getQuoteChar();

    public Boolean getSkipBlankRows();

    public Long getSkipColumns();

    public Boolean getSkipInitialSpace();

    public Long getSkipRows();

    public String getTrim();

    public String getQuoteEscapeChar();

    default public void copyInto(DialectMutable dest, boolean copyNulls) {
        Long l;
        Boolean b;
        String str = this.getCommentPrefix();
        if (str != null || copyNulls) {
            dest.setCommentPrefix(str);
        }
        if ((str = this.getDelimiter()) != null || copyNulls) {
            dest.setDelimiter(str);
        }
        if ((b = this.isDoubleQuote()) != null || copyNulls) {
            dest.setDoubleQuote(b);
        }
        if ((str = this.getEncoding()) != null || copyNulls) {
            dest.setEncoding(str);
        }
        if ((b = this.getHeader()) != null || copyNulls) {
            dest.setHeader(b);
        }
        if ((l = this.getHeaderRowCount()) != null || copyNulls) {
            dest.setHeaderRowCount(l);
        }
        if ((str = this.getLineTerminators()) != null || copyNulls) {
            dest.setLineTerminators(str);
        }
        if ((str = this.getQuoteChar()) != null || copyNulls) {
            dest.setQuoteChar(str);
        }
        if ((str = this.getQuoteEscapeChar()) != null || copyNulls) {
            dest.setQuoteEscapeChar(str);
        }
        if ((b = this.getSkipBlankRows()) != null || copyNulls) {
            dest.setSkipBlankRows(b);
        }
        if ((l = this.getSkipColumns()) != null || copyNulls) {
            dest.setSkipColumns(l);
        }
        if ((b = this.getSkipInitialSpace()) != null || copyNulls) {
            dest.setSkipInitialSpace(b);
        }
        if ((l = this.getSkipRows()) != null || copyNulls) {
            dest.setSkipRows(l);
        }
        if ((str = this.getTrim()) != null || copyNulls) {
            dest.setTrim(str);
        }
    }

    default public List<String> getLineTerminatorList() {
        List result = null;
        String str = this.getLineTerminators();
        if (str != null) {
            try {
                Type type = new TypeToken<List<String>>(){}.getType();
                Gson gson = GsonUtils.createGson();
                result = (List)gson.fromJson(str, type);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (result == null) {
                result = Arrays.asList(str);
            }
        }
        return result;
    }
}

