/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.model.csvw.domain.impl;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import org.aksw.commons.model.csvw.domain.api.Dialect;
import org.aksw.commons.model.csvw.domain.api.DialectMutable;

public class CsvwLib {
    public static List<String> DFT_LINE_TERMINATORS = Arrays.asList("\n", "\r\n", "\n\r", "\r\n\r");
    public static final String END_OF_DATA_KEY = "endOfData";
    public static final String FIELD_SEPARATOR_KEY = "fieldSeparator";
    public static final String LINE_TERMINATOR_KEY = "lineTerminator";

    public static boolean isPresent(String value) {
        return value != null && !value.isEmpty();
    }

    public static Character expectAtMostOneChar(String contextLabel, String str, Character fallbackChar) {
        Character result;
        if (str == null) {
            result = fallbackChar;
            if (result == null) {
                throw new RuntimeException(contextLabel + ": Expected a character but none given (and no fallback specified)");
            }
        } else {
            result = CsvwLib.expectAtMostOneChar(contextLabel, str);
        }
        return result;
    }

    public static Character expectAtMostOneChar(String contextLabel, String str) {
        Character result = null;
        if (str != null) {
            int n = str.length();
            if (n > 1) {
                throw new IllegalArgumentException(contextLabel + ": At most one character expected, got: " + str);
            }
            if (n == 1) {
                result = Character.valueOf(str.charAt(0));
            }
        }
        return result;
    }

    public static Dialect buildEffectiveModel(Dialect src, DialectMutable dest) {
        if (Boolean.TRUE.equals(src.isDoubleQuote())) {
            dest.setQuoteChar("\"");
        }
        if (Boolean.TRUE.equals(src.getHeader())) {
            dest.setHeaderRowCount(1L);
        }
        if (Boolean.TRUE.equals(src.getSkipInitialSpace())) {
            dest.setTrim("start");
        }
        return dest;
    }

    public static Charset getEncoding(Dialect dialect, Charset fallback) {
        return CsvwLib.getEncoding(dialect.getEncoding(), fallback);
    }

    public static Charset getEncoding(String encoding, Charset fallback) {
        Charset result;
        if (!CsvwLib.isPresent(encoding)) {
            result = fallback;
            if (fallback == null) {
                throw new IllegalArgumentException("No charset specified");
            }
        } else {
            result = Charset.forName(encoding);
        }
        return result;
    }

    public static String getExcelColumnLabel(int columnIndex) {
        StringBuilder sb = new StringBuilder();
        for (int v = columnIndex; v >= 0; --v) {
            char c = (char)(97 + v % 26);
            sb.append(c);
            v /= 26;
        }
        String result = sb.reverse().toString();
        return result;
    }
}

