/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.apache;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.aksw.commons.collections.SinglePrefetchIterator;
import org.aksw.commons.util.apache.ApacheLogEntry;

public class ApacheLogEntryIterator
extends SinglePrefetchIterator<ApacheLogEntry>
implements AutoCloseable {
    private BufferedReader reader;
    private boolean closeWhenDone;

    public ApacheLogEntryIterator(InputStream in, boolean closeWhenDone) {
        this.reader = new BufferedReader(new InputStreamReader(in));
    }

    public ApacheLogEntryIterator(BufferedReader reader) {
        this.reader = reader;
    }

    protected ApacheLogEntry prefetch() throws Exception {
        String line;
        while ((line = this.reader.readLine()) != null) {
            try {
                return ApacheLogEntry.parse(line);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return (ApacheLogEntry)this.finish();
    }

    @Override
    public void close() {
        if (this.closeWhenDone) {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

