/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.util.apache;

import com.google.common.io.PatternFilenameFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.aksw.commons.util.apache.ApacheLogEntry;
import org.aksw.commons.util.apache.ApacheLogEntryIterator;
import org.aksw.commons.util.apache.ApacheLogRangeEntryIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheLogDirectory {
    private static final Logger logger = LoggerFactory.getLogger(ApacheLogDirectory.class);
    private NavigableMap<Date, File> dateToFile = new TreeMap<Date, File>();

    public static InputStream open(File file) throws IOException {
        InputStream in = new FileInputStream(file);
        if (file.getName().endsWith(".gz")) {
            in = new GZIPInputStream(in);
        }
        return in;
    }

    public ApacheLogDirectory(File dir, Pattern pattern) throws IOException {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("Argument must be a directory, got: " + String.valueOf(dir));
        }
        for (File file : dir.listFiles((FilenameFilter)new PatternFilenameFilter(pattern))) {
            ApacheLogEntryIterator it = new ApacheLogEntryIterator(ApacheLogDirectory.open(file), true);
            if (!it.hasNext()) continue;
            Date date = ((ApacheLogEntry)it.next()).getDate();
            this.dateToFile.put(date, file);
            it.close();
        }
        logger.debug("Found log files: " + String.valueOf(this.dateToFile));
    }

    public ApacheLogRangeEntryIterator getIterator(Date low, Date high, boolean lowInclusive, boolean highInclusive) {
        Date adjustedHigh;
        NavigableMap<Date, File> subMap = this.dateToFile;
        Date adjustedLow = low == null ? null : this.dateToFile.floorKey(low);
        Date date = adjustedHigh = high == null ? null : this.dateToFile.ceilingKey(high);
        if (adjustedLow != null) {
            subMap = subMap.tailMap(adjustedLow, true);
        }
        if (adjustedHigh != null) {
            subMap = subMap.headMap(adjustedHigh, true);
        }
        logger.debug("Adjust: Creating an iterator from " + String.valueOf(adjustedLow) + " until " + String.valueOf(adjustedHigh) + "; spanning " + subMap.size() + " files.");
        logger.debug("Creating an iterator from " + String.valueOf(low) + " until " + String.valueOf(high) + "; spanning " + subMap.size() + " files.");
        return new ApacheLogRangeEntryIterator(subMap.entrySet().iterator(), low, lowInclusive, high, highInclusive);
    }

    public void main(String[] args) {
    }
}

