/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.jgit.util;

import com.jcraft.jsch.IdentityRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import com.jcraft.jsch.agentproxy.AgentProxyException;
import com.jcraft.jsch.agentproxy.Connector;
import com.jcraft.jsch.agentproxy.RemoteIdentityRepository;
import com.jcraft.jsch.agentproxy.USocketFactory;
import com.jcraft.jsch.agentproxy.connector.SSHAgentConnector;
import com.jcraft.jsch.agentproxy.usocket.JNAUSocketFactory;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jgit.api.TransportConfigCallback;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.util.FS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JgitUtils {
    private static final Logger logger = LoggerFactory.getLogger(JgitUtils.class);

    public static List<Path> listPrivateKeys(Path path) throws IOException {
        List<Path> result = Files.list(path).filter(p -> !p.getFileName().toAbsolutePath().endsWith(".pub")).filter(p -> Files.exists(p.getParent().resolve(p.getFileName().toString() + ".pub"), new LinkOption[0])).collect(Collectors.toList());
        return result;
    }

    public static SshSessionFactory createSshSessionFactory() {
        JschConfigSessionFactory sshSessionFactory = new JschConfigSessionFactory(){

            protected JSch createDefaultJSch(FS fs) throws JSchException {
                SSHAgentConnector con = null;
                try {
                    if (SSHAgentConnector.isConnectorAvailable()) {
                        JNAUSocketFactory usf = new JNAUSocketFactory();
                        con = new SSHAgentConnector((USocketFactory)usf);
                    }
                }
                catch (AgentProxyException e) {
                    System.out.println((Object)e);
                }
                JSch jsch = super.createDefaultJSch(fs);
                if (con != null) {
                    JSch.setConfig((String)"PreferredAuthentications", (String)"publickey");
                    RemoteIdentityRepository identityRepository = new RemoteIdentityRepository((Connector)con);
                    jsch.setIdentityRepository((IdentityRepository)identityRepository);
                }
                return jsch;
            }

            protected void configure(OpenSshConfig.Host host, Session session) {
                session.setConfig("StrictHostKeyChecking", "no");
                session.setUserInfo(new UserInfo(){

                    public String getPassphrase() {
                        System.err.println("Passphrase requested");
                        return null;
                    }

                    public String getPassword() {
                        return null;
                    }

                    public boolean promptPassword(String message) {
                        System.err.println(message);
                        return true;
                    }

                    public boolean promptPassphrase(String message) {
                        System.err.println(message);
                        return true;
                    }

                    public boolean promptYesNo(String message) {
                        System.err.println(message);
                        return true;
                    }

                    public void showMessage(String message) {
                        System.err.println(message);
                    }
                });
            }
        };
        return sshSessionFactory;
    }

    public static TransportConfigCallback createDefaultTransportConfigCallback() {
        SshSessionFactory sshSessionFactory = JgitUtils.createSshSessionFactory();
        return transport -> {
            if (transport instanceof SshTransport) {
                SshTransport sshTransport = (SshTransport)transport;
                sshTransport.setSshSessionFactory(sshSessionFactory);
            }
        };
    }
}

