/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.util.stream;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.aksw.commons.io.util.stream.InputStreamTransform;
import org.aksw.commons.io.util.stream.OutputStreamTransform;

public class OutputStreamTransformOverInputStreamTransform
implements OutputStreamTransform {
    private InputStreamTransform inTransform;

    public OutputStreamTransformOverInputStreamTransform(InputStreamTransform inTransform) {
        this.inTransform = inTransform;
    }

    @Override
    public boolean isPiped() {
        return true;
    }

    @Override
    public InputStreamTransform asInputStreamTransform() {
        return this.inTransform;
    }

    @Override
    public OutputStream apply(OutputStream out) throws IOException {
        PipedInputStream inPipe;
        PipedOutputStream outPipe = new PipedOutputStream();
        try {
            inPipe = new PipedInputStream(outPipe, 65536);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        InputStream in = this.inTransform.apply(inPipe);
        final Thread converterThread = new Thread(() -> {
            try {
                in.transferTo(outPipe);
                out.flush();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        converterThread.start();
        FilterOutputStream r = new FilterOutputStream(this, outPipe){
            final /* synthetic */ OutputStreamTransformOverInputStreamTransform this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            @Override
            public void close() throws IOException {
                converterThread.interrupt();
                try {
                    converterThread.join();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    super.close();
                }
            }
        };
        return r;
    }

    public String toString() {
        return "(outputTransform from " + String.valueOf(this.inTransform) + ")";
    }
}

