/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.util.stream;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Objects;
import org.aksw.commons.io.util.stream.OutputStreamTransform;

public class OutputStreamTransformList
implements OutputStreamTransform {
    private List<OutputStreamTransform> transforms;

    public OutputStreamTransformList() {
        this(List.of());
    }

    public OutputStreamTransformList(List<OutputStreamTransform> transforms) {
        this.transforms = transforms;
    }

    @Override
    public OutputStream apply(OutputStream out) throws IOException {
        Objects.requireNonNull(out);
        OutputStream r = out;
        for (OutputStreamTransform xform : this.transforms) {
            try {
                OutputStream tmp = xform.apply(r);
                Objects.requireNonNull(tmp);
                r = tmp;
            }
            catch (IOException | RuntimeException t) {
                t.addSuppressed(new RuntimeException("Error applying stream transform"));
                r.close();
                throw t;
            }
        }
        return r;
    }
}

