/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.util.stream;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.aksw.commons.io.util.stream.InputStreamTransform;
import org.aksw.commons.io.util.stream.OutputStreamTransform;

public class InputStreamTransformOverOutputStreamTransform
implements InputStreamTransform {
    private OutputStreamTransform outTransform;

    public InputStreamTransformOverOutputStreamTransform(OutputStreamTransform outTransform) {
        this.outTransform = outTransform;
    }

    @Override
    public boolean isPiped() {
        return true;
    }

    @Override
    public OutputStreamTransform asOutputStreamTransform() {
        return this.outTransform;
    }

    @Override
    public InputStream apply(InputStream in) {
        PipedInputStream inPipe;
        PipedOutputStream outPipe = new PipedOutputStream();
        try {
            inPipe = new PipedInputStream(outPipe, 65536);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        final Thread converterThread = new Thread(() -> {
            try (OutputStream out = this.outTransform.apply(outPipe);){
                in.transferTo(out);
                out.flush();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        converterThread.start();
        FilterInputStream r = new FilterInputStream(this, inPipe){
            final /* synthetic */ InputStreamTransformOverOutputStreamTransform this$0;
            {
                this.this$0 = this$0;
                super(arg0);
            }

            @Override
            public void close() throws IOException {
                converterThread.interrupt();
                try {
                    converterThread.join();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    super.close();
                }
            }
        };
        return r;
    }

    public String toString() {
        return "(inputTransform from " + String.valueOf(this.outTransform) + ")";
    }
}

