/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.util;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class UriUtils {
    public static URL toURL(URI uri) {
        URL result;
        try {
            result = uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static URI newURI(String uri) {
        URI result;
        try {
            result = new URI(uri);
        }
        catch (URISyntaxException e) {
            result = null;
        }
        return result;
    }

    public static Optional<URI> tryNewURI(String uri) {
        Optional<URI> result = Optional.ofNullable(UriUtils.newURI(uri));
        return result;
    }

    public static String encodeQueryParamUtf8(String str) {
        return URLEncoder.encode(str, StandardCharsets.UTF_8).replace("%20", "+").replaceAll("%3[aA]", ":").replaceAll("%2[fF]", "/");
    }

    public static String decodeQueryParamUtf8(String str) {
        return URLDecoder.decode(str, StandardCharsets.UTF_8);
    }

    public static Map<String, String> parseQueryStringAsMap(String queryString) {
        Multimap<String, String> multimap = UriUtils.parseQueryStringAsMultimap(queryString);
        return UriUtils.toMap(multimap, LinkedHashMap::new);
    }

    public static <K, V> Map<K, V> toMap(Multimap<K, V> mm, Supplier<? extends Map<K, V>> mapSupplier) {
        return mm.entries().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (u, v) -> u, mapSupplier));
    }

    public static Multimap<String, String> parseQueryStringAsMultimap(String queryString) {
        LinkedHashMultimap result = LinkedHashMultimap.create();
        UriUtils.parseQueryStringAsEntries(queryString, (arg_0, arg_1) -> ((Multimap)result).put(arg_0, arg_1));
        return result;
    }

    public static List<Map.Entry<String, String>> parseQueryStringAsList(String queryString) {
        ArrayList<Map.Entry<String, String>> result = new ArrayList<Map.Entry<String, String>>();
        UriUtils.parseQueryStringAsEntries(queryString, (k, v) -> result.add(new AbstractMap.SimpleImmutableEntry<String, String>((String)k, (String)v)));
        return result;
    }

    public static void parseQueryStringAsEntries(String queryString, BiConsumer<String, String> sink) {
        if (queryString != null && !queryString.isBlank()) {
            for (String param : queryString.split("&")) {
                String[] pair = param.split("=", 2);
                String key = UriUtils.decodeQueryParamUtf8(pair[0]);
                String value = null;
                if (pair.length > 1) {
                    value = UriUtils.decodeQueryParamUtf8(pair[1]);
                }
                sink.accept(key, value);
            }
        }
    }

    public static String toQueryString(Multimap<String, String> args) {
        return UriUtils.toQueryString(args.entries());
    }

    public static String toQueryString(Collection<Map.Entry<String, String>> entries) {
        String tmp = entries.stream().map(e -> {
            String k = (String)e.getKey();
            String v = (String)e.getValue();
            String encodedK = UriUtils.encodeQueryParamUtf8(k);
            String r = v == null ? encodedK : encodedK + "=" + UriUtils.encodeQueryParamUtf8(v);
            return r;
        }).collect(Collectors.joining("&"));
        String result = !tmp.isEmpty() ? tmp : null;
        return result;
    }

    public static URI replaceQueryString(URI uri, String newQueryString) throws URISyntaxException {
        boolean skip = newQueryString == null || newQueryString.isBlank();
        String placeholder = "&&&INTERNAL_PLACEHOLDER&&&";
        String str = new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), skip ? null : placeholder, uri.getFragment()).toString();
        String newStr = skip ? str : str.replace(placeholder, newQueryString);
        return new URI(newStr);
    }
}

