/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.util;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aksw.commons.io.util.PathUtils;
import org.aksw.commons.io.util.symlink.SymbolicLinkStrategy;
import org.aksw.commons.lambda.throwing.ThrowingBiFunction;

public class SymLinkUtils {
    public static Path readSymLinkAbsolute(Path symLink) throws IOException {
        if (!Files.isSymbolicLink(symLink)) {
            throw new IllegalArgumentException("Not a symbolic link: " + String.valueOf(symLink));
        }
        Path symLinkTgt = Files.readSymbolicLink(symLink);
        Path result = SymLinkUtils.resolveSymLinkAbsolute(symLink, symLinkTgt);
        return result;
    }

    public static Path resolveSymLinkAbsolute(Path symLinkSrc, Path symLinkTgt) {
        Path result;
        if (symLinkTgt.isAbsolute()) {
            result = symLinkTgt;
        } else {
            String[] tgtSegments = PathUtils.getPathSegments(symLinkTgt);
            result = PathUtils.resolve(symLinkSrc.getParent(), tgtSegments).normalize().toAbsolutePath();
        }
        return result;
    }

    public static Collection<Path> allocateSymbolicLink(SymbolicLinkStrategy symlinkStrategy, Path rawTarget, Path rawSourceFolder, Function<String, String> fileNameNormalizer, String prefix, String suffix) throws Exception {
        return SymLinkUtils.allocateSymbolicLink(symlinkStrategy, rawTarget, rawSourceFolder, fileNameNormalizer, prefix, suffix, (ThrowingBiFunction<Path, Path, Path>)(ThrowingBiFunction & Serializable)(file, tgt) -> {
            symlinkStrategy.createSymbolicLink((Path)file, (Path)tgt);
            return file;
        });
    }

    public static Collection<Path> allocateSymbolicLink(SymbolicLinkStrategy symlinkStrategy, Path rawTarget, Path rawSourceFolder, Function<String, String> fileNameNormalizer, String prefix, String suffix, ThrowingBiFunction<Path, Path, Path> tgtAndContentToFile) throws Exception {
        Path sourceFolder = rawSourceFolder.normalize();
        Path target = rawTarget.normalize();
        Path relTgt = sourceFolder.relativize(target);
        Path absTarget = target.toAbsolutePath();
        Table<String, Path, Path> existingSymLinks = SymLinkUtils.readSymbolicLinks(symlinkStrategy, rawSourceFolder, fileNameNormalizer, prefix, suffix);
        Set<Path> result = existingSymLinks.cellSet().stream().filter(e -> {
            Path absCand = SymLinkUtils.resolveSymLinkAbsolute((Path)e.getColumnKey(), (Path)e.getValue());
            boolean r = absCand.equals(absTarget);
            return r;
        }).map(Table.Cell::getColumnKey).collect(Collectors.toSet());
        if (result.isEmpty()) {
            int i = 1;
            while (true) {
                String cand;
                Path c;
                if (!Files.exists(c = sourceFolder.resolve(cand = prefix + String.valueOf(i == 1 ? "" : Integer.valueOf(i)) + suffix), LinkOption.NOFOLLOW_LINKS)) {
                    Path tmp = (Path)tgtAndContentToFile.apply((Object)c, (Object)relTgt);
                    result = Collections.singleton(tmp);
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    public static Function<Stream<Path>, Stream<Table.Cell<String, Path, Path>>> streamSymbolicLinks(SymbolicLinkStrategy symlinkStrategy, Function<String, String> fileNameHarmonizer, String prefix, String suffix) throws IOException {
        return pathStream -> pathStream.filter(symlinkStrategy::isSymbolicLink).flatMap(path -> {
            Stream<Object> r;
            boolean isAccepted;
            String rawFileName = path.getFileName().toString();
            String fileName = (String)fileNameHarmonizer.apply(rawFileName);
            boolean bl = isAccepted = fileName.startsWith(prefix) && fileName.endsWith(suffix);
            if (isAccepted) {
                try {
                    Path linkTarget = symlinkStrategy.readSymbolicLink((Path)path);
                    r = Stream.of(Tables.immutableCell((Object)fileName, (Object)path, (Object)linkTarget));
                }
                catch (Exception e) {
                    r = Stream.empty();
                }
            } else {
                r = Stream.empty();
            }
            return r;
        });
    }

    public static Table<String, Path, Path> readSymbolicLinks(SymbolicLinkStrategy symlinkStrategy, Path sourceFolder, Function<String, String> filenameNormalizer, String prefix, String suffix) throws IOException {
        HashBasedTable result = HashBasedTable.create();
        try (Stream<Path> stream = Files.list(sourceFolder);){
            SymLinkUtils.streamSymbolicLinks(symlinkStrategy, filenameNormalizer, prefix, suffix).apply(stream).forEach(arg_0 -> SymLinkUtils.lambda$readSymbolicLinks$0((Table)result, arg_0));
        }
        return result;
    }

    private static /* synthetic */ void lambda$readSymbolicLinks$0(Table result, Table.Cell cell) {
        result.put((Object)((String)cell.getRowKey()), (Object)((Path)cell.getColumnKey()), (Object)((Path)cell.getValue()));
    }
}

