/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.util.channel;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import org.aksw.commons.io.util.channel.ReadableByteChannelDecoratorBase;

public class ReadableByteChannelWithLimitByNewline<T extends SeekableByteChannel>
extends ReadableByteChannelDecoratorBase<T> {
    protected long nextSplitOffset;
    protected boolean isInEofState = false;
    protected long bytesRead = 0L;
    protected ByteBuffer excessBuffer;

    public ReadableByteChannelWithLimitByNewline(T delegate, long nextSplitOffset) {
        super(delegate);
        this.nextSplitOffset = nextSplitOffset;
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        int result = 0;
        while (result == 0) {
            if (this.isInEofState) {
                result = -1;
            } else {
                boolean isInNextSplit;
                long pos = ((SeekableByteChannel)this.getDelegate()).position();
                boolean bl = isInNextSplit = pos >= this.nextSplitOffset;
                if (!isInNextSplit) {
                    result = ((SeekableByteChannel)this.getDelegate()).read(byteBuffer);
                } else {
                    if (this.excessBuffer == null) {
                        this.excessBuffer = ByteBuffer.allocate(4096);
                    } else {
                        this.excessBuffer.clear();
                    }
                    int n = ((SeekableByteChannel)this.getDelegate()).read(this.excessBuffer);
                    if (n >= 0) {
                        int i;
                        for (i = 0; i < n; ++i) {
                            byte b = this.excessBuffer.get(i);
                            if (b != 10) continue;
                            ++i;
                            this.isInEofState = true;
                            break;
                        }
                        this.excessBuffer.position(0);
                        this.excessBuffer.limit(i);
                        byteBuffer.duplicate().put(this.excessBuffer);
                        result = i;
                    } else {
                        result = n;
                    }
                }
            }
            if (result > 0) {
                this.bytesRead += (long)result;
                break;
            }
            if (result == -1) {
                this.isInEofState = true;
                break;
            }
            if (result == -2) {
                result = 0;
                continue;
            }
            if (result != 0) break;
            throw new RuntimeException("Zero-byte read.");
        }
        return result;
    }

    public long getBytesRead() {
        return this.bytesRead;
    }
}

