/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.util;

import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;

public class PathUtils {
    public static Path resolve(Path basePath, String ... segments) {
        return PathUtils.resolve(basePath, Arrays.asList(segments));
    }

    public static Path resolve(Path basePath, Iterable<String> segments) {
        Path result = basePath;
        for (String segment : segments) {
            result = result.resolve(segment);
        }
        return result;
    }

    public static String[] getPathSegments(Path path) {
        int n = path.getNameCount();
        String[] result = new String[n];
        Iterator<Path> it = path.iterator();
        for (int i = 0; i < n; ++i) {
            String segment;
            result[i] = segment = it.next().toString();
        }
        return result;
    }

    public static String[] splitBySlash(String str) {
        String[] result = Arrays.asList(str.split("/+")).stream().map(String::trim).filter(x -> !x.isEmpty()).collect(Collectors.toList()).toArray(new String[0]);
        return result;
    }

    public static String join(String ... segments) {
        String result = Arrays.asList(segments).stream().collect(Collectors.joining("/"));
        return result;
    }

    public static Map.Entry<Path, Closeable> resolveFsAndPath(String fsUri, String pathStr) throws IOException {
        Closeable fsCloseActionTmp;
        FileSystem fs;
        Path dbPath = null;
        if (fsUri != null && !fsUri.isBlank()) {
            fs = FileSystems.newFileSystem(URI.create(fsUri), Collections.emptyMap());
            fsCloseActionTmp = () -> fs.close();
        } else {
            fs = FileSystems.getDefault();
            fsCloseActionTmp = () -> {};
        }
        Closeable closeAction = fsCloseActionTmp;
        try {
            if (pathStr != null && !pathStr.isBlank()) {
                dbPath = fs.getPath(pathStr, new String[0]).toAbsolutePath();
            }
        }
        catch (Exception e) {
            try {
                closeAction.close();
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
            throw new RuntimeException(e);
        }
        return Maps.immutableEntry(dbPath, (Object)closeAction);
    }
}

