/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.util;

import com.google.common.collect.Lists;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.stream.Stream;
import org.aksw.commons.io.util.FileChannelUtils;
import org.aksw.commons.io.util.OutputConfig;
import org.aksw.commons.io.util.PathUtils;
import org.aksw.commons.io.util.StdIo;
import org.aksw.commons.lambda.throwing.ThrowingConsumer;

public class FileUtils {
    private static final int DEFAULT_BUFFER_SIZE = 8192;

    public static OutputStream newOutputStream(OutputConfig config) throws IOException {
        OutputStream result;
        String fileName = config.getTargetFile();
        boolean allowOverwrite = config.isOverwriteAllowed();
        if (fileName == null || "-".equals(fileName)) {
            result = StdIo.openStdOutWithCloseShield();
        } else {
            Path path = Path.of(fileName, new String[0]);
            result = allowOverwrite ? Files.newOutputStream(path, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING) : Files.newOutputStream(path, StandardOpenOption.CREATE_NEW);
        }
        return result;
    }

    public static void deleteRecursivelyIfExists(Path path, RecursiveDeleteOption ... options) throws IOException {
        if (Files.exists(path, new LinkOption[0])) {
            MoreFiles.deleteRecursively((Path)path, (RecursiveDeleteOption[])options);
        }
    }

    public static Path getFirstExistingAncestor(Path path) {
        Path result = path == null ? null : (Files.exists(path, new LinkOption[0]) ? path : FileUtils.getFirstExistingAncestor(path.getParent()));
        return result;
    }

    public static boolean deleteFileIfExistsAndThenDeleteEmptyFolders(Path path, Path baseFolder, boolean alsoDeleteBaseFolder) throws IOException {
        boolean result = Files.deleteIfExists(path);
        if ((path = path.getParent()) != null) {
            FileUtils.deleteEmptyFolders(path, baseFolder, alsoDeleteBaseFolder);
        }
        return result;
    }

    public static void deleteEmptyFolders(Path path, Path baseFolder, boolean alsoDeleteBase) {
        while (path.startsWith(baseFolder) && (alsoDeleteBase || !path.equals(baseFolder))) {
            if (Files.exists(path, new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0])) {
                try {
                    Files.deleteIfExists(path);
                }
                catch (IOException e) {
                    break;
                }
            }
            path = path.getParent();
        }
    }

    @Deprecated
    public static void moveAtomic(Path srcFile, Path tgtPath) throws IOException {
        try {
            Files.move(srcFile, tgtPath, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (AtomicMoveNotSupportedException e) {
            try (FileChannel srcChannel = FileChannel.open(srcFile, StandardOpenOption.READ);
                 FileChannel tgtChannel = FileChannel.open(tgtPath, StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
                long n = srcChannel.size();
                FileChannelUtils.transferFromFully(tgtChannel, srcChannel, 0L, n, null);
                tgtChannel.force(true);
            }
            Files.delete(srcFile);
        }
    }

    public static void moveAtomicIfSupported(Consumer<String> warnCallback, Path source, Path target) throws IOException {
        try {
            Files.move(source, target, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (AtomicMoveNotSupportedException e) {
            if (warnCallback != null) {
                warnCallback.accept(String.format("Atomic move from %s to %s failed, falling back to copy", source, target));
            }
            Files.move(source, target, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public static void safeCreate(Path target, OverwritePolicy overwritePolicy, ThrowingConsumer<OutputStream> writer) throws Exception {
        FileUtils.safeCreate(target, null, overwritePolicy, writer);
    }

    public static FileTime getLastModifiedTimeOrNull(Path path) {
        FileTime result = null;
        try {
            BasicFileAttributes attr = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
            result = attr.lastModifiedTime();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static void safeCreate(Path target, Function<OutputStream, OutputStream> encoder, OverwritePolicy overwritePolicy, ThrowingConsumer<OutputStream> writer) throws Exception {
        Boolean fileExists;
        Objects.requireNonNull(overwritePolicy);
        boolean isCheckedOverwrite = OverwritePolicy.OVERWRITE.equals((Object)overwritePolicy) || OverwritePolicy.OVERWRITE_ERROR.equals((Object)overwritePolicy);
        boolean isOverwriteMode = isCheckedOverwrite || OverwritePolicy.OVERWRITE_ALWAYS.equals((Object)overwritePolicy);
        FileTime targetFileTimeAtStart = isCheckedOverwrite ? FileUtils.getLastModifiedTimeOrNull(target) : null;
        String fileName = target.getFileName().toString();
        String randomPart = "." + new Random().nextInt();
        String tmpFileName = "." + fileName + randomPart + ".tmp";
        Path tmpFile = target.resolveSibling(tmpFileName);
        Boolean bl = fileExists = OverwritePolicy.SKIP.equals((Object)overwritePolicy) || OverwritePolicy.ERROR.equals((Object)overwritePolicy) ? Boolean.valueOf(Files.exists(target, new LinkOption[0])) : null;
        if (Boolean.TRUE.equals(fileExists) && OverwritePolicy.ERROR.equals((Object)overwritePolicy)) {
            throw new FileAlreadyExistsException(target.toAbsolutePath().toString());
        }
        if (!Boolean.TRUE.equals(fileExists) || !OverwritePolicy.SKIP.equals((Object)overwritePolicy)) {
            Path parent = target.getParent();
            if (parent != null) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            boolean allowOverwrite = isOverwriteMode;
            try (OutputStream raw = Files.newOutputStream(tmpFile, allowOverwrite ? StandardOpenOption.CREATE : StandardOpenOption.CREATE_NEW);
                 OutputStream out = encoder != null ? encoder.apply(raw) : raw;){
                writer.accept((Object)out);
                out.flush();
            }
            boolean doFinalMove = true;
            if (targetFileTimeAtStart != null) {
                FileTime tmpFileTime;
                if (OverwritePolicy.OVERWRITE_ERROR.equals((Object)overwritePolicy)) {
                    FileTime targetFileTimeAtEnd = FileUtils.getLastModifiedTimeOrNull(target);
                    if (targetFileTimeAtEnd.compareTo(targetFileTimeAtStart) != 0) {
                        Files.delete(tmpFile);
                        throw new ConcurrentModificationException("Concurrent modification to file: " + String.valueOf(target));
                    }
                } else if (OverwritePolicy.OVERWRITE.equals((Object)overwritePolicy) && (tmpFileTime = FileUtils.getLastModifiedTimeOrNull(tmpFile)) != null && tmpFileTime.compareTo(targetFileTimeAtStart) < 0) {
                    doFinalMove = false;
                }
            }
            if (doFinalMove) {
                FileUtils.moveAtomicIfSupported(null, tmpFile, target);
            } else {
                Files.delete(tmpFile);
            }
        }
    }

    public void deleteDirectoryIfEmpty(Path path) throws IOException {
        boolean isDirectory = Files.isDirectory(path, new LinkOption[0]);
        if (isDirectory) {
            boolean isEmpty;
            boolean bl = isEmpty = Files.list(path).count() == 0L;
            if (isEmpty) {
                Files.delete(path);
            }
        }
    }

    public static List<Path> listPaths(Path basePath, String glob) throws IOException {
        ArrayList result = null;
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(basePath, glob);){
            result = Lists.newArrayList(stream.iterator());
        }
        return result;
    }

    public static <T> T readObject(Path target) throws IOException, ClassNotFoundException {
        Object obj;
        try (ObjectInputStream in = new ObjectInputStream(Files.newInputStream(target, StandardOpenOption.READ));){
            obj = in.readObject();
        }
        return (T)obj;
    }

    public static void writeObject(Path target, Object obj) throws IOException {
        try (ObjectOutputStream out = new ObjectOutputStream(Files.newOutputStream(target, StandardOpenOption.WRITE, StandardOpenOption.CREATE));){
            out.writeObject(obj);
            out.flush();
        }
    }

    public static long sizeOfDirectory(Path dirPath) throws IOException {
        return FileUtils.sizeOfDirectory(dirPath, null);
    }

    public static long sizeOfDirectory(Path dirPath, final PathMatcher fileMatcher) throws IOException {
        final AtomicLong totalSize = new AtomicLong(0L);
        Files.walkFileTree(dirPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                boolean isAccepted;
                boolean bl = isAccepted = fileMatcher == null || fileMatcher.matches(file);
                if (isAccepted) {
                    long contrib = attrs.size();
                    totalSize.addAndGet(contrib);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }
        });
        return totalSize.get();
    }

    public static Stream<Path> ancestors(Path start, boolean reflexive) {
        Stream<Path> r = FileUtils.ancestors(start);
        if (!reflexive) {
            r = r.skip(1L);
        }
        return r;
    }

    public static Stream<Path> ancestors(Path start) {
        return Stream.iterate(start, node -> node.getParent() != null, Path::getParent);
    }

    public static Path findInAncestors(Path start, String fileName) {
        return FileUtils.ancestors(start).filter(folder -> Files.exists(folder.resolve(fileName), new LinkOption[0])).map(folder -> folder.resolve(fileName)).findFirst().orElse(null);
    }

    public static void copyDirectory(Path source, Path target, CopyOption ... options) throws IOException {
        Path src = source.toAbsolutePath();
        Path tgt = target.toAbsolutePath();
        Files.createDirectories(tgt, new FileAttribute[0]);
        FileUtils.copyDirectoryInternal(src, tgt, options);
    }

    protected static void copyDirectoryInternal(Path source, Path target, CopyOption ... options) throws IOException {
        try (Stream<Path> children = Files.list(source);){
            Iterator it = children.iterator();
            while (it.hasNext()) {
                Path src = (Path)it.next();
                Path relPath = source.relativize(src);
                String[] segments = PathUtils.getPathSegments(relPath);
                Path tgt = PathUtils.resolve(target, segments);
                if (Files.isDirectory(src, new LinkOption[0])) {
                    Files.createDirectories(tgt, new FileAttribute[0]);
                    FileUtils.copyDirectoryInternal(src, tgt, options);
                    continue;
                }
                if (!Files.isRegularFile(src, new LinkOption[0])) continue;
                Files.copy(src, tgt, options);
            }
        }
    }

    public static long copy(Path source, OutputStream out, IntConsumer contribCallback) throws IOException {
        Objects.requireNonNull(out);
        try (InputStream in = Files.newInputStream(source, new OpenOption[0]);){
            long l = FileUtils.transferTo(out, in, contribCallback);
            return l;
        }
    }

    public static long transferTo(OutputStream out, InputStream in, IntConsumer contribCallback) throws IOException {
        int read;
        Objects.requireNonNull(out, "out");
        long transferred = 0L;
        byte[] buffer = new byte[8192];
        while ((read = in.read(buffer, 0, 8192)) >= 0) {
            out.write(buffer, 0, read);
            transferred += (long)read;
            contribCallback.accept(read);
        }
        return transferred;
    }

    public static enum OverwritePolicy {
        ERROR,
        OVERWRITE,
        SKIP,
        OVERWRITE_ALWAYS,
        OVERWRITE_ERROR;

    }
}

