/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.util;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import org.aksw.commons.io.util.FileChannelUtils;
import org.aksw.commons.io.util.PathTransfer;

public class FileMerger {
    protected List<PathTransfer> pathTransfers;
    protected Path destPath;
    protected long totalTransferSize;
    protected Thread runThread = null;
    protected long transferred = 0L;
    protected Collection<Consumer<? super FileMerger>> progressListeners = Collections.synchronizedList(new LinkedList());

    public FileMerger(Path destPath, List<PathTransfer> pathTransfers, long totalTransferSize) {
        this.destPath = destPath;
        this.pathTransfers = pathTransfers;
        this.totalTransferSize = totalTransferSize;
    }

    public Runnable addProgressListener(Consumer<? super FileMerger> progressListener) {
        this.progressListeners.add(progressListener);
        return () -> this.progressListeners.remove(progressListener);
    }

    public void notifyProgressListeners() {
        for (Consumer<? super FileMerger> listener : this.progressListeners) {
            listener.accept(this);
        }
    }

    public double getProgress() {
        return (double)this.transferred / (double)this.totalTransferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        FileMerger fileMerger = this;
        synchronized (fileMerger) {
            if (this.runThread != null) {
                this.runThread.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws IOException {
        FileMerger fileMerger = this;
        synchronized (fileMerger) {
            if (this.runThread != null) {
                throw new IllegalStateException("A merge task is already running");
            }
            this.runThread = Thread.currentThread();
        }
        this.transferred = 0L;
        try (FileChannel out = FileChannel.open(this.destPath, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);){
            for (PathTransfer pathTransfer : this.pathTransfers) {
                FileChannelUtils.transferFromFully(out, pathTransfer, contrib -> {
                    this.transferred += contrib.longValue();
                    this.notifyProgressListeners();
                });
            }
        }
        finally {
            fileMerger = this;
            synchronized (fileMerger) {
                this.runThread = null;
            }
        }
    }

    public static FileMerger create(Path destPath, List<Path> srcPaths) throws IOException {
        ArrayList<PathTransfer> pathTransfers = new ArrayList<PathTransfer>(srcPaths.size());
        long nextOffset = 0L;
        for (int i = 0; i < srcPaths.size(); ++i) {
            Path srcPath = srcPaths.get(i);
            long contrib = Files.size(srcPath);
            pathTransfers.add(new PathTransfer(srcPath, nextOffset, contrib));
            nextOffset += contrib;
        }
        return new FileMerger(destPath, pathTransfers, nextOffset);
    }
}

