/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.util;

import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import org.aksw.commons.io.util.PathUtils;
import org.aksw.commons.io.util.UriUtils;
import org.aksw.commons.util.string.StringUtils;
import org.apache.commons.lang3.ArrayUtils;

public class UriToPathUtils {
    public static String[] toPathSegments(URI uri) {
        String query;
        String path;
        int port;
        ArrayList<String> parts = new ArrayList<String>();
        String host = uri.getHost();
        if (host != null) {
            parts.addAll(Arrays.asList(UriToPathUtils.javaifyHostnameSegments(host)));
        }
        if ((port = uri.getPort()) != -1) {
            parts.add(Integer.toString(port));
        }
        if ((path = uri.getPath()) != null) {
            String tmp = path.replaceAll("~", "_");
            parts.addAll(Arrays.asList(PathUtils.splitBySlash(tmp)));
        }
        if ((query = uri.getQuery()) != null) {
            parts.addAll(Arrays.asList(PathUtils.splitBySlash(query)));
        }
        String[] result = parts.toArray(new String[0]);
        return result;
    }

    public static String[] toPathSegments(String uri) {
        URI u = UriUtils.newURI(uri);
        String[] result = UriToPathUtils.toPathSegments(u);
        return result;
    }

    public static String[] javaifyHostnameSegments(String hostName) {
        Object[] result = hostName.split("\\.+");
        ArrayUtils.reverse((Object[])result);
        return result;
    }

    public static String javaifyHostname(String hostName) {
        String[] parts = UriToPathUtils.javaifyHostnameSegments(hostName);
        String result = Arrays.asList(parts).stream().collect(Collectors.joining("/"));
        return result;
    }

    @Deprecated
    public static Path resolvePath(URI uri) {
        String a = Optional.ofNullable(uri.getHost()).map(UriToPathUtils::javaifyHostname).orElse("");
        String b = uri.getPort() == -1 ? "" : Integer.toString(uri.getPort());
        String pathStr = Optional.ofNullable(uri.getPath()).orElse("").replaceAll("~", "_");
        Path result = Paths.get(".", new String[0]).resolve(a).resolve(b).resolve((a.isEmpty() && b.isEmpty() ? "" : ".") + pathStr).resolve(Optional.ofNullable(uri.getQuery()).orElse("")).normalize();
        return result;
    }

    @Deprecated
    public static Path resolvePath(String uri) {
        Path result;
        Path tmp;
        URI u = UriUtils.newURI(uri);
        Path path = tmp = u == null ? Paths.get(StringUtils.urlEncode((String)uri), new String[0]) : UriToPathUtils.resolvePath(u);
        if (tmp.isAbsolute()) {
            Path root = tmp.getRoot();
            result = root.relativize(tmp);
        } else {
            result = tmp;
        }
        return result;
    }
}

