/*
 * Decompiled with CFR 0.152.
 */
package net.sansa_stack.nio.util;

import com.google.common.primitives.Ints;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import net.sansa_stack.nio.util.SeekableByteChannelDecoratorBase;

public class InterruptingSeekableByteChannel
extends SeekableByteChannelDecoratorBase<SeekableByteChannel> {
    protected long interruptPos;

    public InterruptingSeekableByteChannel(SeekableByteChannel decoratee, long interruptPos) {
        super(decoratee);
        this.interruptPos = interruptPos;
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        int toRead;
        long pos = this.position();
        int remainingUntilInterrupt = pos < this.interruptPos ? Ints.saturatedCast((long)(this.interruptPos - pos)) : Integer.MAX_VALUE;
        int capacity = byteBuffer.remaining();
        int n = toRead = remainingUntilInterrupt == 0 ? capacity : Math.min(capacity, remainingUntilInterrupt);
        if (toRead != capacity) {
            byteBuffer = byteBuffer.duplicate();
            byteBuffer.limit(byteBuffer.position() + toRead);
        }
        int result = super.read(byteBuffer);
        return result;
    }
}

