/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.util;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.function.Consumer;
import org.aksw.commons.io.util.PathTransfer;

public class FileChannelUtils {
    public static long transferFromFully(FileChannel dest, PathTransfer pathTransfer, Consumer<Long> contribCallback) throws IOException {
        return FileChannelUtils.transferFromFully(dest, pathTransfer.getPath(), pathTransfer.getTargetOffset(), pathTransfer.getLength(), contribCallback);
    }

    public static long transferFromFully(FileChannel destChannel, Path srcPath, long targetOffset, long length, Consumer<Long> contribCallback) throws IOException {
        try (FileChannel srcChannel = FileChannel.open(srcPath, StandardOpenOption.READ);){
            long l = FileChannelUtils.transferFromFully(destChannel, srcChannel, targetOffset, length, contribCallback);
            return l;
        }
    }

    public static long transferFromFully(FileChannel destChannel, FileChannel srcChannel, long destOffset, long length, Consumer<Long> contribCallback) throws IOException {
        long transferred = 0L;
        int zeroCount = 0;
        Thread currentThread = Thread.currentThread();
        while (transferred < length && !currentThread.isInterrupted()) {
            long remainingLength = length - transferred;
            long n = destChannel.transferFrom(srcChannel, destOffset + transferred, remainingLength);
            if (n == 0L) {
                long srcChannelSize;
                if (++zeroCount >= 10 && length > (srcChannelSize = srcChannel.size())) {
                    length = srcChannelSize;
                }
            } else {
                zeroCount = 0;
            }
            srcChannel.position(transferred += n);
            if (contribCallback == null) continue;
            contribCallback.accept(n);
        }
        return transferred;
    }
}

