/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.process.pipe;

import java.io.InputStream;
import java.nio.file.Path;
import java.util.function.Consumer;
import org.aksw.commons.io.endpoint.FileCreation;
import org.aksw.commons.io.process.pipe.ProcessPipeUtils;
import org.aksw.commons.io.process.pipe.ProcessSink;

public class ProcessSinkImpl
implements ProcessSink {
    protected ProcessBuilder processBuilder;
    protected Consumer<? super Process> postStartAction;
    protected Process process;

    public ProcessSinkImpl(ProcessBuilder processBuilder, Consumer<? super Process> postStart) {
        this.processBuilder = processBuilder;
        this.postStartAction = postStart;
    }

    protected synchronized Process startProcess() {
        if (this.process != null) {
            throw new RuntimeException("Process already started");
        }
        this.process = ProcessPipeUtils.startProcess(this.processBuilder);
        return this.process;
    }

    @Override
    public InputStream getInputStream() {
        this.startProcess();
        this.postStartAction.accept(this.process);
        InputStream result = this.process.getInputStream();
        return result;
    }

    @Override
    public FileCreation redirectTo(Path path) {
        this.processBuilder.redirectOutput(path.toFile());
        this.startProcess();
        this.postStartAction.accept(this.process);
        FileCreation result = ProcessPipeUtils.createFileCreation(this.process, path);
        return result;
    }
}

