/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.hadoop.binseach.v2;

import com.google.common.primitives.Ints;
import java.io.IOException;
import java.io.InputStream;
import org.aksw.commons.io.binseach.BinSearchScanState;
import org.aksw.commons.io.buffer.array.ArrayOps;
import org.aksw.commons.io.buffer.ring.RingBufferForBytes;
import org.aksw.commons.io.hadoop.binseach.v2.BinSearchUtils;
import org.aksw.commons.io.input.ReadableChannel;
import org.aksw.commons.io.input.ReadableChannels;
import org.aksw.commons.io.input.ReadableSource;

public class ReadableByteChannelForLinesMatchingPrefix
implements ReadableChannel<byte[]> {
    protected ReadableChannel<byte[]> channel;
    protected BinSearchScanState state;
    protected byte delimiter = (byte)10;
    protected long position;
    protected long knownDelimPos;
    protected boolean isCurrentLineValidated = true;
    protected RingBufferForBytes buffer;
    protected boolean endReached = false;

    public ReadableByteChannelForLinesMatchingPrefix(ReadableChannel<byte[]> channel, BinSearchScanState state) {
        this.channel = channel;
        this.state = state;
        this.position = state.firstDelimPos;
        this.knownDelimPos = state.matchDelimPos;
    }

    public int read(byte[] array, int offset, int length) throws IOException {
        int result;
        if (this.position < this.knownDelimPos) {
            int remaining = Ints.saturatedCast((long)(this.knownDelimPos - this.position));
            int l = Math.min(length, remaining);
            result = this.channel.read((Object)array, offset, l);
        } else {
            if (this.endReached) {
                result = -1;
            } else {
                int l = this.state.prefixBytes.length;
                if (this.buffer == null) {
                    this.buffer = new RingBufferForBytes(Math.max(4096, l));
                }
                if (!this.isCurrentLineValidated) {
                    this.buffer.fill(this.channel, l);
                    if (this.buffer.available() < l) {
                        result = -1;
                    } else {
                        try (InputStream in = ReadableChannels.newInputStream((ReadableSource)this.buffer.shallowClone());){
                            int cmp = BinSearchUtils.compareToPrefix(in, this.state.prefixBytes);
                            this.isCurrentLineValidated = cmp == 0;
                        }
                    }
                }
            }
            if (!this.isCurrentLineValidated) {
                this.endReached = true;
                result = -1;
            } else {
                int n = this.buffer.available();
                if (n == 0) {
                    n = this.buffer.fill(this.channel);
                }
                if (n == 0) {
                    result = -1;
                } else {
                    int i;
                    for (i = 0; i < n; ++i) {
                        byte c = this.buffer.get(i);
                        if (c != this.delimiter) continue;
                        ++i;
                        this.isCurrentLineValidated = false;
                        break;
                    }
                    result = ReadableChannels.readFully((ReadableSource)this.buffer, (Object)array, (int)offset, (int)i);
                }
            }
        }
        if (result > 0) {
            this.position += (long)result;
        }
        return result;
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public void close() throws IOException {
        this.channel.close();
    }

    public ArrayOps<byte[]> getArrayOps() {
        return ArrayOps.BYTE;
    }
}

