/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.hadoop.binseach.v2;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.nio.file.Path;
import java.util.function.Supplier;
import org.aksw.commons.io.binseach.BinarySearcher;
import org.aksw.commons.io.hadoop.binseach.v2.BinSearchLevelCache;
import org.aksw.commons.io.hadoop.binseach.v2.BinSearchResourceCache;
import org.aksw.commons.io.hadoop.binseach.v2.BinarySearcherOverBlockSource;
import org.aksw.commons.io.hadoop.binseach.v2.BinarySearcherOverPlainSource;
import org.aksw.commons.io.hadoop.binseach.v2.Block;
import org.aksw.commons.io.hadoop.binseach.v2.BlockSource;
import org.aksw.commons.io.hadoop.binseach.v2.SeekableReadableChannelSources;
import org.aksw.commons.io.input.SeekableReadableChannelSource;
import org.aksw.commons.io.input.SeekableReadableSourceWithMonitor;
import org.apache.hadoop.io.compress.SplittableCompressionCodec;

public class BinarySearchBuilder {
    protected Path path;
    protected SeekableReadableChannelSource<byte[]> source;
    protected SplittableCompressionCodec codec;
    protected BinSearchResourceCache resourceCache;

    public static BinarySearchBuilder newBuilder() {
        return new BinarySearchBuilder();
    }

    public BinarySearchBuilder setSource(Path path) {
        this.path = path;
        return this;
    }

    public BinarySearchBuilder setSource(SeekableReadableChannelSource<byte[]> source) {
        this.source = source;
        return this;
    }

    public BinarySearchBuilder setCodec(SplittableCompressionCodec codec) {
        this.codec = codec;
        return this;
    }

    public BinarySearchBuilder setResourceCache(BinSearchResourceCache resourceCache) {
        this.resourceCache = resourceCache;
        return this;
    }

    public BinarySearcher build() {
        Object result;
        Supplier<BinSearchResourceCache.CacheEntry> cacheSupplier = this.resourceCache != null ? () -> this.resourceCache.getOrCreate(this.path) : () -> new BinSearchResourceCache.CacheEntry(BinSearchLevelCache.dftCache(), (Cache<Long, Block>)Caffeine.newBuilder().maximumSize(16L).build());
        SeekableReadableSourceWithMonitor finalSource = this.source != null ? this.source : new SeekableReadableSourceWithMonitor(this.path);
        finalSource = SeekableReadableChannelSources.monitor(finalSource);
        if (this.codec == null) {
            result = new BinarySearcherOverPlainSource((SeekableReadableChannelSource<byte[]>)finalSource, cacheSupplier);
        } else {
            BlockSource blockSource = BlockSource.of(finalSource, this.codec);
            result = new BinarySearcherOverBlockSource(blockSource, cacheSupplier);
        }
        return result;
    }
}

