/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.hadoop.binseach.v2;

import java.io.IOException;
import java.io.InputStream;
import org.aksw.commons.io.binseach.BinSearchScanState;
import org.aksw.commons.io.hadoop.SeekableInputStream;
import org.aksw.commons.io.hadoop.SeekableInputStreams;
import org.aksw.commons.io.hadoop.binseach.v2.BinSearchLevelCache;
import org.aksw.commons.io.hadoop.binseach.v2.BinarySearcherOverPlainSource;
import org.aksw.commons.io.hadoop.binseach.v2.Match;
import org.aksw.commons.io.hadoop.binseach.v2.ReadableByteChannelForLinesMatchingPrefix;
import org.aksw.commons.io.hadoop.binseach.v2.SearchMode;
import org.aksw.commons.io.input.ReadableChannel;
import org.aksw.commons.io.input.ReadableChannels;
import org.aksw.commons.io.input.SeekableReadableChannel;

public class BinSearchUtils {
    public static long readUntilDelimiter(InputStream in, byte delimiter, long allowedSearchBytes) throws IOException {
        int c;
        long result = 0L;
        do {
            if (result >= allowedSearchBytes) {
                result = -1L;
                break;
            }
            c = in.read();
            if (c == -1) {
                result = -1L;
                break;
            }
            ++result;
        } while (c != delimiter);
        return result;
    }

    public static int compareToPrefix(InputStream in, byte[] prefix) throws IOException {
        int cmp = 0;
        for (int i = 0; i < prefix.length; ++i) {
            int b = in.read();
            if (b == -1) {
                cmp = -1;
                break;
            }
            byte x = prefix[i];
            cmp = x - b;
            if (cmp != 0) break;
        }
        return cmp;
    }

    public static InputStream configureStream(SeekableReadableChannel<byte[]> channel, long end, byte[] prefix, BinSearchLevelCache levelCache) throws IOException {
        InputStream result;
        SeekableInputStream in = SeekableInputStreams.create(channel);
        Match match = BinarySearcherOverPlainSource.binarySearch(in, SearchMode.BOTH, 0, 0L, end, end, (byte)10, prefix, levelCache);
        if (match != null) {
            in.position(match.start());
            BinSearchScanState scanState = new BinSearchScanState();
            scanState.firstDelimPos = match.start();
            scanState.matchDelimPos = match.end();
            scanState.prefixBytes = prefix;
            scanState.size = Long.MAX_VALUE;
            result = ReadableChannels.newInputStream((ReadableChannel)new ReadableByteChannelForLinesMatchingPrefix((ReadableChannel<byte[]>)SeekableInputStreams.wrap(in), scanState));
        } else {
            in.close();
            result = InputStream.nullInputStream();
        }
        return result;
    }
}

