/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.hadoop;

import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.util.Objects;
import org.aksw.commons.io.buffer.array.ArrayOps;
import org.aksw.commons.io.hadoop.ReadableChannelWithBlockAdvertisement;
import org.aksw.commons.io.hadoop.SeekableInputStream;
import org.aksw.commons.io.input.GetPosition;
import org.aksw.commons.io.input.InputStreamOverChannel;
import org.aksw.commons.io.input.SeekableReadableChannel;
import org.aksw.commons.io.input.SeekableReadableChannelBase;
import org.aksw.commons.io.input.SeekableReadableChannels;
import org.aksw.commons.io.input.SetPosition;
import org.apache.hadoop.fs.Seekable;

public class SeekableInputStreams {
    public static Seekable createSeekable(final GetPosition getPosition, final SetPosition setPosition) {
        return new Seekable(){

            public void seek(long pos) throws IOException {
                setPosition.accept(pos);
            }

            public long getPos() throws IOException {
                return getPosition.call();
            }

            public boolean seekToNewSource(long targetPos) throws IOException {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <T extends ReadableByteChannel> SeekableInputStream create(T channel, GetPositionFn<? super T> getPosition, SetPositionFn<? super T> setPosition) {
        return SeekableInputStreams.create((InputStream)new InputStreamOverChannel(channel), () -> getPosition.apply((Object)channel), position -> setPosition.apply((Object)channel, position));
    }

    public static SeekableReadableChannel<byte[]> wrap(final SeekableInputStream in) {
        Objects.requireNonNull(in);
        return new SeekableReadableChannelBase<byte[]>(){

            public SeekableReadableChannel<byte[]> cloneObject() {
                throw new UnsupportedOperationException();
            }

            public int read(byte[] array, int position, int length) throws IOException {
                return in.read(array, position, length);
            }

            public ArrayOps<byte[]> getArrayOps() {
                return ArrayOps.BYTE;
            }

            public long position() {
                return in.position();
            }

            public void position(long pos) {
                in.position(pos);
            }

            protected void closeActual() throws Exception {
                in.close();
            }
        };
    }

    public static <T extends ReadableByteChannel> SeekableInputStream create(SeekableByteChannel channel) {
        return SeekableInputStreams.create(channel, SeekableByteChannel::position, SeekableByteChannel::position);
    }

    public static <T extends ReadableByteChannel> SeekableInputStream create(SeekableReadableChannel<byte[]> channel) {
        SeekableByteChannel adaptedChannel = SeekableReadableChannels.adapt(channel);
        return SeekableInputStreams.create(adaptedChannel);
    }

    public static <T extends ReadableByteChannel> SeekableInputStream create(InputStream in, GetPosition getPosition, SetPosition setPosition) {
        Seekable seekable = SeekableInputStreams.createSeekable(getPosition, setPosition);
        return new SeekableInputStream(in, seekable);
    }

    public static SeekableInputStream create(InputStream in, Seekable seekable) {
        return new SeekableInputStream(in, seekable);
    }

    public static ReadableChannelWithBlockAdvertisement advertiseEndOfBlock(InputStream decodedIn) throws IOException {
        return SeekableInputStreams.advertiseEndOfBlock(decodedIn, -2);
    }

    public static ReadableChannelWithBlockAdvertisement advertiseEndOfBlock(InputStream decodedIn, int endOfBlockMarker) throws IOException {
        return new ReadableChannelWithBlockAdvertisement(decodedIn, endOfBlockMarker);
    }

    @FunctionalInterface
    public static interface GetPositionFn<T> {
        public long apply(T var1) throws IOException;
    }

    @FunctionalInterface
    public static interface SetPositionFn<T> {
        public void apply(T var1, long var2) throws IOException;
    }
}

