/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.hadoop.binseach.v2;

import com.github.benmanes.caffeine.cache.Cache;
import com.google.common.primitives.Ints;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.aksw.commons.io.buffer.array.ArrayOps;
import org.aksw.commons.io.buffer.plain.Buffer;
import org.aksw.commons.io.buffer.plain.BufferOverArray;
import org.aksw.commons.io.hadoop.binseach.v2.Block;
import org.aksw.commons.io.hadoop.binseach.v2.BlockSource;
import org.aksw.commons.io.hadoop.binseach.v2.BlockSourceChannel;
import org.aksw.commons.io.input.SeekableReadableChannel;
import org.aksw.commons.io.input.SeekableReadableChannelBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeekableReadableChannelOverBlocks
extends SeekableReadableChannelBase<byte[]> {
    private static final Logger logger = LoggerFactory.getLogger(SeekableReadableChannelOverBlocks.class);
    protected BlockSource blockSource;
    protected BlockSourceChannel channel;
    protected long firstBlockId;
    protected long currentBlockLogicalOffset;
    protected Block currentBlock;
    protected long currentBlockId;
    protected long currentLogicalPos;
    protected Cache<Long, Block> globalCache;
    protected NavigableMap<Long, Block> blockIdToBlock;
    protected NavigableMap<Long, Long> logicalPosToBlockId;

    public Collection<Block> getKnownBlocks() {
        return this.blockIdToBlock.values();
    }

    public SeekableReadableChannelOverBlocks(BlockSource blockSource, long firstBlockId, Cache<Long, Block> globalCache) {
        this.blockSource = blockSource;
        this.firstBlockId = firstBlockId;
        this.channel = null;
        this.globalCache = globalCache;
        this.blockIdToBlock = new TreeMap<Long, Block>();
        this.logicalPosToBlockId = new TreeMap<Long, Long>();
    }

    public SeekableReadableChannel<byte[]> cloneObject() {
        throw new UnsupportedOperationException();
    }

    protected boolean isPosValidInBlock() {
        boolean result = this.currentLogicalPos >= this.currentBlockLogicalOffset && this.currentLogicalPos < this.currentBlockLogicalOffset + (long)this.currentBlock.size();
        return result;
    }

    protected void ensureCurrentBlock() {
        if (this.currentLogicalPos < 0L) {
            throw new RuntimeException("Negative logical position - should not happen");
        }
        Block block = null;
        while (this.currentBlock == null || !this.isPosValidInBlock()) {
            long logicalBlockOffset;
            long blockId;
            Map.Entry logicalBlockOffsetAndId;
            NavigableMap<Long, Long> headMap = this.logicalPosToBlockId.headMap(this.currentLogicalPos, true).descendingMap();
            Iterator it = headMap.entrySet().iterator();
            Map.Entry entry = logicalBlockOffsetAndId = it.hasNext() ? it.next() : null;
            if (logicalBlockOffsetAndId == null) {
                blockId = this.firstBlockId;
                logicalBlockOffset = 0L;
            } else {
                blockId = (Long)logicalBlockOffsetAndId.getValue();
                logicalBlockOffset = (Long)logicalBlockOffsetAndId.getKey();
            }
            block = this.getOrLoadBlock(blockId, logicalBlockOffset);
            int blockSize = block == null ? -1 : block.size();
            long nextLogicalBlockOffset = logicalBlockOffset + (long)blockSize;
            if (blockSize != -1 && this.currentLogicalPos >= logicalBlockOffset && this.currentLogicalPos < nextLogicalBlockOffset) {
                this.currentBlock = block;
                this.currentBlockId = blockId;
                this.currentBlockLogicalOffset = logicalBlockOffset;
                break;
            }
            long nextBlockId = block.getNextBlockId();
            if (nextBlockId == -1L) {
                this.currentBlock = null;
                this.currentBlockId = -1L;
                this.currentBlockLogicalOffset = -1L;
                break;
            }
            this.logicalPosToBlockId.put(nextLogicalBlockOffset, nextBlockId);
        }
    }

    public long getStartingBlockSize() {
        Block block = this.getOrLoadBlock(this.firstBlockId, 0L);
        return block.size();
    }

    protected Block getOrLoadBlock(long blockId, long logicalBlockOffset) {
        Block block = this.blockIdToBlock.computeIfAbsent(blockId, bid -> {
            Block r = (Block)this.globalCache.get(bid, blkId2 -> {
                try {
                    if (this.channel != null && this.channel.getCurrentBlockId() != blockId) {
                        this.channel.close();
                        this.channel = null;
                    }
                    if (this.channel == null) {
                        this.channel = this.blockSource.newReadableChannel(blockId, true);
                    }
                    Block s = SeekableReadableChannelOverBlocks.loadBlock(this.blockSource, this.channel, blkId2);
                    return s;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            this.logicalPosToBlockId.put(logicalBlockOffset, blockId);
            return r;
        });
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Got/loaded blockId %d of size %d - followed by: %d", blockId, block.size(), block.getNextBlockId()));
        }
        return block;
    }

    public int read(byte[] array, int position, int length) throws IOException {
        int result;
        this.ensureCurrentBlock();
        if (this.currentBlock == null) {
            result = -1;
        } else {
            int positionInBlock = Ints.checkedCast((long)(this.currentLogicalPos - this.currentBlockLogicalOffset));
            int remaining = this.currentBlock.size() - positionInBlock;
            if (remaining > 0) {
                int requestLen = Math.min(remaining, length);
                result = this.currentBlock.getBuffer().readInto((Object)array, position, (long)positionInBlock, requestLen);
            } else {
                throw new RuntimeException("should not happen");
            }
        }
        if (result > 0) {
            this.currentLogicalPos += (long)result;
        }
        return result;
    }

    public ArrayOps<byte[]> getArrayOps() {
        return ArrayOps.BYTE;
    }

    public long position() throws IOException {
        return this.currentLogicalPos;
    }

    protected void closeActual() throws Exception {
        if (this.channel != null) {
            this.channel.close();
            this.channel = null;
        }
        super.closeActual();
    }

    public void position(long pos) throws IOException {
        if (pos < 0L) {
            throw new IllegalArgumentException("Negative position: " + pos);
        }
        this.currentLogicalPos = pos;
        this.currentBlock = null;
        this.currentBlockId = -1L;
        this.currentBlockLogicalOffset = -1L;
    }

    public static Block loadBlock(BlockSource blockSource, BlockSourceChannel channel, long thisBlockId) throws IOException {
        ByteArrayOutputStream blockBytes = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        while (true) {
            int blockSize;
            int n;
            if ((n = channel.read(buffer, 0, buffer.length)) > 0) {
                blockBytes.write(buffer, 0, n);
                continue;
            }
            if (n == -1 || n == -2 && (blockSize = blockBytes.size()) != 0) break;
        }
        byte[] data = blockBytes.toByteArray();
        BufferOverArray buf = BufferOverArray.create((ArrayOps)ArrayOps.BYTE, (Object)data);
        long nextBlockId = channel.getCurrentBlockId();
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Loaded blockId %d of size %d - followed by blockId %d", thisBlockId, blockBytes.size(), nextBlockId));
        }
        if (thisBlockId == nextBlockId) {
            nextBlockId = -1L;
        }
        Block result = new Block(blockSource, (Buffer<byte[]>)buf, thisBlockId, nextBlockId);
        return result;
    }
}

