/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.hadoop.binseach.v2;

import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.aksw.commons.io.hadoop.binseach.v2.BinSearchCache;
import org.aksw.commons.io.hadoop.binseach.v2.HeaderRecord;
import org.aksw.commons.util.lock.LockUtils;

class BinSearchCacheFixed
implements BinSearchCache {
    protected NavigableMap<Long, Long> fixedDispositions;
    protected Map<Long, HeaderRecord> fixedHeaders;
    protected ReadWriteLock dispositionLock = new ReentrantReadWriteLock();
    protected ReadWriteLock headerLock = new ReentrantReadWriteLock();

    public BinSearchCacheFixed() {
        this.fixedDispositions = new TreeMap<Long, Long>();
        this.fixedHeaders = new HashMap<Long, HeaderRecord>();
    }

    @Override
    public long getDisposition(long position) {
        return (Long)LockUtils.runWithLock((Lock)this.dispositionLock.readLock(), () -> {
            long result = -1L;
            if (this.fixedHeaders.containsKey(position)) {
                result = position;
            } else {
                long to;
                Map.Entry<Long, Long> e = this.fixedDispositions.floorEntry(position);
                if (e != null && position <= (to = e.getValue().longValue())) {
                    result = to;
                }
            }
            return result;
        });
    }

    @Override
    public void setDisposition(long from, long to) {
        LockUtils.runWithLock((Lock)this.dispositionLock.writeLock(), () -> {
            Map.Entry<Long, Long> e = this.fixedDispositions.floorEntry(from);
            if (e != null) {
                long cachedFrom = e.getKey();
                long cachedTo = e.getValue();
                if (cachedTo > to) {
                    throw new IllegalStateException(String.format("The upper endoint overlaps with an existing entry: [%d, %d] -> [%d, %d]", from, to, cachedFrom, cachedTo));
                }
                if (cachedTo == to) {
                    if (from < cachedFrom) {
                        this.fixedDispositions.remove(cachedFrom);
                        this.fixedDispositions.put(from, to);
                    }
                } else {
                    if (from <= cachedTo) {
                        throw new IllegalStateException(String.format("Overlap with an existing entry: [%d, %d] -> [%d, %d]", from, to, cachedFrom, cachedTo));
                    }
                    this.fixedDispositions.put(from, to);
                }
            } else {
                this.fixedDispositions.put(from, to);
            }
        });
    }

    @Override
    public HeaderRecord getHeader(long position) {
        return (HeaderRecord)LockUtils.runWithLock((Lock)this.headerLock.readLock(), () -> {
            HeaderRecord result = this.fixedHeaders.get(position);
            return result;
        });
    }

    @Override
    public void setHeader(HeaderRecord headerRecord) {
        LockUtils.runWithLock((Lock)this.headerLock.writeLock(), () -> this.fixedHeaders.put(headerRecord.position(), headerRecord));
    }
}

