/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.hadoop.binseach.v2;

import com.google.common.base.Stopwatch;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import org.aksw.commons.io.binseach.BinarySearcher;
import org.aksw.commons.io.hadoop.binseach.v2.BinarySearchBuilder;
import org.aksw.commons.io.hadoop.binseach.v2.BlockSource;
import org.aksw.commons.io.hadoop.binseach.v2.BlockSourceChannel;
import org.aksw.commons.io.input.ReadableChannel;
import org.aksw.commons.io.input.ReadableChannelSupplier;
import org.aksw.commons.io.input.ReadableChannels;
import org.apache.hadoop.io.compress.BZip2Codec;
import org.apache.hadoop.io.compress.SplittableCompressionCodec;

public class BinCount {
    public static void main(String[] args) throws IOException {
        Path bzip2Path = Paths.get("/media/raven/T9/raven/datasets/wikidata/2024-08-24_wikidata-truthy.sorted.nt.bz2", new String[0]);
        Path plainPath = Path.of("/home/raven/tmp/2018-04-04-Amenity.node.sorted.nt", new String[0]);
        BinarySearcher searcher = BinarySearchBuilder.newBuilder().setSource(bzip2Path).setCodec((SplittableCompressionCodec)new BZip2Codec()).build();
        Stopwatch sw = Stopwatch.createStarted();
        List splits = searcher.parallelSearch(null).toList();
        System.out.println("splits: " + splits.size());
        List<Map.Entry> indexedSplits = IntStream.range(0, splits.size()).mapToObj(i -> Map.entry(i, (ReadableChannelSupplier)splits.get(i))).toList();
        System.out.println("Count: " + indexedSplits.parallelStream().mapToLong(e -> {
            int i = (Integer)e.getKey();
            ReadableChannelSupplier source = (ReadableChannelSupplier)e.getValue();
            long r = 0L;
            try (BufferedReader br = new BufferedReader(new InputStreamReader(ReadableChannels.newInputStream((ReadableChannel)source.newChannel()), StandardCharsets.UTF_8));){
                String line;
                while ((line = br.readLine()) != null) {
                    ++r;
                }
                System.out.println("Contribution from split #x:" + r);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            return r;
        }).sum());
        System.out.println("Time Taken: " + (double)sw.elapsed(TimeUnit.MILLISECONDS) * 0.001);
    }

    public static void main2(String[] args) throws IOException {
        byte[] wd;
        Path path = Path.of("/media/raven/T9/raven/datasets/wikidata/2024-08-24_wikidata-truthy.sorted.nt.bz2", new String[0]);
        byte[] allPrefix = "<http://linkedgeodata.org/".getBytes();
        byte[] prefix = "<http://linkedgeodata.org/geometry/node1202810066>".getBytes();
        byte[] first = "<http://linkedgeodata.org/geometry/node1000036734>".getBytes();
        byte[] last = "<http://linkedgeodata.org/triplify/node999596437>".getBytes();
        byte[] lookup = wd = "<http://www.wikidata.org/entity/Q24075>".getBytes();
        BlockSource blockSource = BlockSource.of(path, (SplittableCompressionCodec)new BZip2Codec());
        long pos = 1L;
        for (int x = 0; x < 0; ++x) {
            BlockSourceChannel channel = blockSource.newReadableChannel(pos, true);
            try (InputStream in = ReadableChannels.newInputStream((ReadableChannel)channel);){
                long startBlockId = channel.getStartingBlockId();
                Long adjustedBlockId = channel.getCurrentBlockId();
                System.out.println(String.format("Transitioned from %d to %d and adjusted to %d", pos, startBlockId, adjustedBlockId));
                pos = startBlockId + 1L;
                for (int i = 0; i < 5; ++i) {
                    int c;
                    long beforeBlkId = channel.getCurrentBlockId();
                    long bytesRead = 0L;
                    while ((c = in.read()) >= 0) {
                        ++bytesRead;
                    }
                    System.out.println(String.format("  iteration %d: block %d reached block %d with %d bytes", i, beforeBlkId, channel.getCurrentBlockId(), bytesRead));
                }
                continue;
            }
        }
    }

    public static void orderTest() {
        List<Integer> ids = IntStream.range(0, 10).boxed().toList();
        List<String> letters = IntStream.range(97, 106).mapToObj(x -> Character.toString((char)x)).toList();
        List list = ids.parallelStream().flatMap(x -> letters.stream().map(y -> x + y)).toList();
        System.out.println(list);
    }
}

