/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.hadoop.binseach.bz2;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;

public abstract class ReadableByteChannelBase
implements ReadableByteChannel {
    protected int maxReadSize;
    protected boolean isOpen = true;

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public void close() throws IOException {
        if (!this.isOpen) {
            throw new RuntimeException("Already closed");
        }
        this.isOpen = false;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        if (!this.isOpen) {
            throw new ClosedChannelException();
        }
        if (this.isUnderlyingEntityKnownToBeClosed()) {
            throw new ClosedChannelException();
        }
        int result = this.readActual(dst);
        return result;
    }

    protected boolean isUnderlyingEntityKnownToBeClosed() {
        return false;
    }

    protected abstract int readActual(ByteBuffer var1) throws IOException;
}

