/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.hadoop.binseach.bz2;

import com.google.common.base.Stopwatch;
import com.google.common.primitives.Ints;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.concurrent.ThreadSafe;
import org.aksw.commons.io.hadoop.binseach.bz2.ReadableByteChannelBase;
import org.aksw.commons.io.seekable.api.Seekable;
import org.aksw.commons.io.util.channel.ChannelFactory;

@ThreadSafe
public class BufferOverInputStream
implements ChannelFactory<Seekable> {
    protected byte[][] buckets;
    protected BucketPointer activeEnd;
    protected long knownDataSize = 0L;
    protected InputStream dataSupplier;
    protected int minReadSize;
    protected int maxReadSize;
    protected boolean isDataSupplierConsumed;

    public long getKnownDataSize() {
        return this.knownDataSize;
    }

    public boolean isDataSupplierConsumed() {
        return this.isDataSupplierConsumed;
    }

    public static BufferOverInputStream create(InputStream in, int maxReadSize, int ... preconfiguredBucketSizes) {
        BufferOverInputStream result = new BufferOverInputStream(maxReadSize, in);
        return result;
    }

    public static long getPosition(byte[][] buckets, int idx, int pos) {
        long result = 0L;
        for (int i = 0; i < idx; ++i) {
            result += (long)buckets[i].length;
        }
        return result += (long)pos;
    }

    public static BucketPointer getPointer(byte[][] buckets, BucketPointer end, long pos) {
        byte[] bucket;
        int n;
        long r;
        int i;
        long tmp = pos;
        int eidx = end.idx;
        int epos = end.pos;
        for (i = 0; i < eidx && (r = tmp - (long)(n = (bucket = buckets[i]).length)) >= 0L; ++i) {
            tmp -= (long)n;
        }
        BucketPointer result = i == end.idx && tmp > (long)epos ? null : new BucketPointer(i, Ints.checkedCast((long)tmp));
        return result;
    }

    public Seekable newChannel() {
        return new ByteArrayChannel(0L, null);
    }

    public BufferOverInputStream(int initialBucketSize, InputStream dataSupplier) {
        if (initialBucketSize <= 0) {
            throw new IllegalArgumentException("Bucket size must not be 0");
        }
        this.buckets = new byte[8][];
        this.buckets[0] = new byte[initialBucketSize];
        this.dataSupplier = dataSupplier;
        this.minReadSize = 8192;
        this.maxReadSize = 8192;
        this.activeEnd = new BucketPointer(0, 0);
    }

    protected int nextBucketSize() {
        long activeSize = this.buckets[this.activeEnd.idx].length;
        int maxBucketSize = 0x3FFFFFFF;
        int nextSize = Math.min(Ints.saturatedCast((long)(activeSize * 2L)), maxBucketSize);
        return nextSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doRead(ByteArrayChannel reader, ByteBuffer dst) {
        int result = 0;
        BucketPointer pointer = reader.pointer;
        if (pointer == null) {
            BucketPointer end = this.activeEnd;
            pointer = BufferOverInputStream.getPointer(this.buckets, end, reader.pos);
            if (pointer == null) {
                if (this.isDataSupplierConsumed) {
                    return -1;
                }
                long requestedPos = reader.pos;
                this.loadDataUpTo(requestedPos);
                end = this.activeEnd;
                pointer = BufferOverInputStream.getPointer(this.buckets, end, reader.pos);
                if (pointer == null) {
                    if (this.isDataSupplierConsumed) {
                        return -1;
                    }
                    throw new IllegalStateException("Should not happen: Could not map pointer position despite all data known");
                }
            }
            reader.pointer = pointer;
        }
        int bucketIdx = pointer.idx;
        int bucketPos = pointer.pos;
        while (true) {
            int remainingBucketLen;
            int remainingDstLen;
            if ((remainingDstLen = dst.remaining()) == 0) {
                if (result != 0) break;
                result = -1;
                break;
            }
            byte[] currentBucket = this.buckets[bucketIdx];
            BucketPointer end = this.activeEnd;
            boolean isInLastBucket = bucketIdx == end.idx;
            int n = remainingBucketLen = isInLastBucket ? end.pos - bucketPos : currentBucket.length - bucketPos;
            if (remainingBucketLen == 0) {
                if (isInLastBucket) {
                    if (result != 0) break;
                    if (!this.isDataSupplierConsumed) {
                        BufferOverInputStream bufferOverInputStream = this;
                        synchronized (bufferOverInputStream) {
                            if (bucketPos == end.pos && bucketIdx == end.idx && !this.isDataSupplierConsumed) {
                                this.loadData(dst.limit());
                                continue;
                            }
                        }
                    } else {
                        result = -1;
                    }
                } else {
                    ++bucketIdx;
                    bucketPos = 0;
                    continue;
                }
            }
            int n2 = Math.min(remainingDstLen, remainingBucketLen);
            dst.put(currentBucket, bucketPos, n2);
            result += n2;
            pointer.pos = bucketPos += n2;
            reader.pos += (long)n2;
            pointer.idx = bucketIdx;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadDataUpTo(long requestedPos) {
        while (!this.isDataSupplierConsumed && this.knownDataSize <= requestedPos) {
            BufferOverInputStream bufferOverInputStream = this;
            synchronized (bufferOverInputStream) {
                if (!this.isDataSupplierConsumed && this.knownDataSize <= requestedPos) {
                    int needed = Ints.saturatedCast((long)(requestedPos - this.knownDataSize));
                    this.loadData(needed);
                }
            }
        }
    }

    protected void loadData(int needed) {
        if (!this.isDataSupplierConsumed) {
            this.ensureCapacityInActiveBucket();
            byte[] activeBucket = this.buckets[this.activeEnd.idx];
            int len = Math.min(needed, this.maxReadSize);
            len = Math.max(len, this.minReadSize);
            len = Math.min(len, activeBucket.length - this.activeEnd.pos);
            if (len != 0) {
                int n;
                try {
                    n = this.dataSupplier.read(activeBucket, this.activeEnd.pos, len);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                if (n > 0) {
                    this.activeEnd.pos += n;
                    this.knownDataSize += (long)n;
                } else if (n == -1) {
                    this.isDataSupplierConsumed = true;
                } else {
                    if (n == 0) {
                        throw new IllegalStateException("Data supplier returned 0 bytes");
                    }
                    throw new IllegalStateException("Invalid return value: " + n);
                }
            }
        }
    }

    protected void ensureCapacityInActiveBucket() {
        byte[] activeBucket = this.buckets[this.activeEnd.idx];
        int capacity = activeBucket.length - this.activeEnd.pos;
        if (capacity == 0) {
            int nextBucketSize = this.nextBucketSize();
            if (nextBucketSize == 0) {
                throw new IllegalStateException("Bucket of size 0 generated");
            }
            int newEndIdx = this.activeEnd.idx + 1;
            if (newEndIdx >= this.buckets.length) {
                int numNewBuckets = this.buckets.length * 2;
                byte[][] newBuckets = new byte[numNewBuckets][];
                System.arraycopy(this.buckets, 0, newBuckets, 0, this.buckets.length);
                this.buckets = newBuckets;
            }
            this.buckets[newEndIdx] = new byte[nextBucketSize];
            this.activeEnd = new BucketPointer(newEndIdx, 0);
        }
    }

    public static void main(String[] args) throws Exception {
        int n = 10000;
        byte[] data = new byte[10 * n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < 10; ++j) {
                data[i * 10 + j] = (byte)(97 + j);
            }
        }
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        BufferOverInputStream b = BufferOverInputStream.create(in, 2, new int[0]);
        Seekable s = b.newChannel();
        ByteBuffer buf = ByteBuffer.allocate(5);
        s.nextPos(5001);
        s.read(buf);
        System.out.println(Arrays.toString(buf.array()));
        for (int i = 0; i < 10; ++i) {
            long pos = s.getPos();
            byte ch = s.get(i);
            System.out.println("i: " + i + " pos: " + pos + " ch: " + ch);
        }
    }

    public static void main2(String[] args) throws Exception {
        Random rand = new Random(0L);
        Stopwatch sw = Stopwatch.createUnstarted();
        for (int i = 0; i < 1000; ++i) {
            if (i == 100) {
                sw.start();
            }
            int dataLength = rand.nextInt(10000);
            byte[] baseData = new byte[dataLength];
            rand.nextBytes(baseData);
            int maxReadLength = rand.nextInt(1000) + 1;
            ByteArrayInputStream in = new ByteArrayInputStream(baseData);
            BufferOverInputStream buffer = BufferOverInputStream.create(in, maxReadLength, new int[0]);
            IntStream.range(0, 1000).mapToObj(x -> x).collect(Collectors.toList()).stream().map(x -> {
                int start = rand.nextInt(dataLength);
                int tmpLen = rand.nextInt(dataLength / 2);
                int end = Math.min(start + tmpLen, baseData.length);
                int len = end - start;
                byte[] expectedData = new byte[len];
                System.arraycopy(baseData, start, expectedData, 0, len);
                byte[] actualData = new byte[len];
                try {
                    ByteBuffer buf = ByteBuffer.wrap(actualData);
                    try (Seekable channel = buffer.newChannel();){
                        channel.setPos((long)start);
                        while (channel.read(buf) > 0) {
                        }
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                if (expectedData.equals(actualData)) {
                    throw new RuntimeException("Actual and expected results differed");
                }
                return "foo";
            }).count();
        }
        System.out.println((double)sw.elapsed(TimeUnit.MILLISECONDS) * 0.001);
    }

    public void close() throws Exception {
        this.dataSupplier.close();
    }

    public static class BucketPointer {
        int idx;
        int pos;

        public BucketPointer(int idx, int pos) {
            this.idx = idx;
            this.pos = pos;
        }

        public String toString() {
            return "BucketPointer [idx=" + this.idx + ", pos=" + this.pos + "]";
        }
    }

    public class ByteArrayChannel
    extends ReadableByteChannelBase
    implements SeekableByteChannel,
    Seekable {
        protected long pos = 0L;
        protected BucketPointer pointer = null;

        public ByteArrayChannel(long pos, BucketPointer pointer) {
            this.pos = pos;
            this.pointer = pointer;
        }

        @Override
        public ByteArrayChannel position(long pos) {
            this.pos = pos;
            this.pointer = null;
            return this;
        }

        @Override
        public long position() {
            return this.pos;
        }

        @Override
        public int readActual(ByteBuffer dst) throws IOException {
            int result = BufferOverInputStream.this.doRead(this, dst);
            return result;
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long size() throws IOException {
            this.checkNext(1, false);
            return BufferOverInputStream.this.knownDataSize;
        }

        public long loadAll() throws IOException {
            BufferOverInputStream.this.loadDataUpTo(Long.MAX_VALUE);
            return BufferOverInputStream.this.knownDataSize;
        }

        @Override
        public SeekableByteChannel truncate(long size) throws IOException {
            throw new UnsupportedOperationException();
        }

        public Seekable clone() {
            return new ByteArrayChannel(this.pos, this.pointer);
        }

        public long getPos() throws IOException {
            return this.position();
        }

        public void setPos(long pos) throws IOException {
            this.position(pos);
        }

        public void posToStart() throws IOException {
            this.position(-1L);
        }

        public void posToEnd() throws IOException {
            BufferOverInputStream.this.loadDataUpTo(Long.MAX_VALUE);
            this.pos = BufferOverInputStream.this.knownDataSize;
            this.pointer = null;
        }

        public boolean isPosBeforeStart() throws IOException {
            return this.pos < 0L;
        }

        public boolean isPosAfterEnd() throws IOException {
            BufferOverInputStream.this.loadDataUpTo(this.pos + 1L);
            boolean result = this.pos >= BufferOverInputStream.this.knownDataSize;
            return result;
        }

        public String readString(int len) throws IOException {
            throw new UnsupportedOperationException();
        }

        public int checkNext(int len, boolean changePos) throws IOException {
            long remainingKnownBytes = BufferOverInputStream.this.knownDataSize - 1L - this.pos;
            if (remainingKnownBytes < (long)len) {
                BufferOverInputStream.this.loadDataUpTo(this.pos + (long)len);
                remainingKnownBytes = BufferOverInputStream.this.knownDataSize - 1L - this.pos;
            }
            int r = Math.min(len, Ints.saturatedCast((long)remainingKnownBytes));
            if (changePos) {
                if (this.pointer != null) {
                    int available;
                    int remaining = r;
                    while (remaining > (available = BufferOverInputStream.this.buckets[this.pointer.idx].length - 1 - this.pointer.pos)) {
                        remaining -= available;
                        ++this.pointer.idx;
                        this.pointer.pos = -1;
                    }
                    this.pointer.pos += remaining;
                }
                this.pos += (long)r;
            }
            return r;
        }

        public byte get() throws IOException {
            byte result;
            if (this.pointer == null) {
                BufferOverInputStream.this.loadDataUpTo(this.pos);
                this.pointer = BufferOverInputStream.getPointer(BufferOverInputStream.this.buckets, BufferOverInputStream.this.activeEnd, this.pos);
            }
            if (this.pointer.pos == BufferOverInputStream.this.buckets[this.pointer.idx].length) {
                ByteBuffer tmp = ByteBuffer.allocate(1);
                this.read(tmp);
                result = tmp.get(0);
            } else {
                result = BufferOverInputStream.this.buckets[this.pointer.idx][this.pointer.pos];
            }
            return result;
        }

        public int checkPrev(int len, boolean changePos) throws IOException {
            long delta;
            long l = delta = (long)len > this.pos ? this.pos : (long)len;
            if (changePos) {
                block4: {
                    if (this.pointer != null) {
                        int remaining = Ints.checkedCast((long)delta);
                        while (remaining > this.pointer.pos) {
                            if (this.pointer.idx == 0) {
                                this.pointer.pos = 0;
                                break block4;
                            }
                            remaining -= this.pointer.pos;
                            --this.pointer.idx;
                            this.pointer.pos = BufferOverInputStream.this.buckets[this.pointer.idx].length;
                        }
                        this.pointer.pos -= remaining;
                    }
                }
                this.pos -= delta;
            }
            return (int)delta;
        }
    }
}

