/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.hadoop.binseach.v2;

import com.google.common.primitives.Ints;
import org.aksw.commons.io.buffer.plain.Buffer;
import org.aksw.commons.io.hadoop.binseach.v2.BlockSource;

public class Block {
    protected long thisBlockId;
    protected long nextBlockId;
    protected Buffer<byte[]> buffer;
    protected BlockSource blockSource;

    public Block(BlockSource blockSource, Buffer<byte[]> buffer, long thisBlockId, long nextBlockId) {
        this.blockSource = blockSource;
        this.buffer = buffer;
        this.thisBlockId = thisBlockId;
        this.nextBlockId = nextBlockId;
        if (nextBlockId == thisBlockId) {
            throw new IllegalArgumentException(String.format("This and next block ids are the same %d - %d", thisBlockId, nextBlockId));
        }
    }

    public Block(Buffer<byte[]> buffer, long thisBlockId, long nextBlockId) {
        this(null, buffer, thisBlockId, nextBlockId);
    }

    public Buffer<byte[]> getBuffer() {
        return this.buffer;
    }

    public long getNextBlockId() {
        return this.nextBlockId;
    }

    public long getThisBlockId() {
        return this.thisBlockId;
    }

    public int size() {
        try {
            return Ints.checkedCast((long)this.buffer.size());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

