/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.hadoop.binseach.v2;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.geom.Point2D;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.aksw.commons.io.hadoop.binseach.v2.LinearTo2DMapper;

public class SourceAccessVisualizer
extends JPanel {
    private static final long serialVersionUID = 1L;
    private LinearTo2DMapper mapper;

    public SourceAccessVisualizer(LinearTo2DMapper mapper) {
        this.mapper = mapper;
        this.setPreferredSize(new Dimension(mapper.getWidth(), mapper.getHeight()));
    }

    public void addRect(Graphics g, long offset, long end, Color color) {
        Point2D a = this.mapper.map(offset);
        Point2D o = this.mapper.map(end);
        int startRow = (int)a.getY();
        int endRow = (int)o.getY();
        g.setColor(Color.RED);
        int h = Math.min(1, (int)this.mapper.getPixelHeight());
        if (startRow == endRow) {
            int w = Math.max(1, (int)(o.getX() - a.getX()));
            g.fillRect((int)a.getX(), startRow, w, h);
        } else {
            int w = Math.min(1, this.mapper.getWidth() - (int)o.getX());
            g.fillRect((int)a.getX(), startRow, w, h);
            int deltaRow = endRow - startRow;
            if (deltaRow - 1 > 0) {
                g.fillRect(0, startRow + 1, this.mapper.getWidth(), (int)((float)(deltaRow - 1) * this.mapper.getPixelHeight()));
            }
            g.fillRect(0, endRow, (int)o.getX(), h);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.setBackground(Color.BLACK);
        this.addRect(g, 35000L, 70000L, Color.RED);
    }

    private Color getColorForFrequency(double frequency) {
        int colorValue = (int)(255.0 * frequency / 10.0);
        return new Color(colorValue, 0, 255 - colorValue);
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Byte Frequency Heat Map");
        SourceAccessVisualizer canvas = new SourceAccessVisualizer(new LinearTo2DMapper(100000L, 800, 600));
        frame.setDefaultCloseOperation(3);
        frame.add(canvas);
        frame.pack();
        frame.setVisible(true);
    }
}

