/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.hadoop.binseach.v2;

import java.awt.Point;
import java.awt.geom.Point2D;

class LinearTo2DMapper {
    private long dataLength;
    private final int width;
    private final int height;
    private final float pixelHeight;
    private final float ratio;
    private final float cellBaseSize;

    public LinearTo2DMapper(long length, int width, int height) {
        this.dataLength = length;
        this.width = width;
        this.height = height;
        this.ratio = (float)width / (float)height;
        this.cellBaseSize = (float)Math.sqrt((float)length / this.ratio);
        float neededRows = (float)this.dataLength / (float)width + 1.0f;
        this.pixelHeight = Math.max(1.0f, neededRows / (float)height);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public float getPixelHeight() {
        return this.pixelHeight;
    }

    public float getPixelWidth() {
        return 1.0f;
    }

    public Point2D map(long pos) {
        int rowId = (int)((float)pos / (float)this.width);
        int colId = (int)(pos - (long)(rowId * this.width));
        int finalRow = (int)((float)rowId * this.pixelHeight);
        return new Point(colId, finalRow);
    }
}

