/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.commons.io.hadoop.binseach.v2;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.aksw.commons.io.buffer.array.ArrayOps;
import org.aksw.commons.io.hadoop.ReadableChannelWithBlockAdvertisement;
import org.aksw.commons.io.hadoop.SeekableInputStream;
import org.aksw.commons.io.hadoop.SeekableInputStreams;
import org.aksw.commons.io.input.SeekableReadableChannel;
import org.aksw.commons.io.input.SeekableReadableChannels;
import org.apache.hadoop.io.compress.SplitCompressionInputStream;
import org.apache.hadoop.io.compress.SplittableCompressionCodec;

public class BlockSourceChannel
implements SeekableReadableChannel<byte[]> {
    protected final SplittableCompressionCodec codec;
    protected final SeekableReadableChannel<byte[]> encodedChannel;
    protected long decodedChannelStart;
    protected ReadableChannelWithBlockAdvertisement decodedChannel;
    protected int positionInBlock;
    protected ByteBuffer pendingRead = ByteBuffer.allocate(1);
    protected SplitCompressionInputStream decodedIn;
    protected boolean blockMode;

    public BlockSourceChannel(SeekableReadableChannel<byte[]> seekable, SplittableCompressionCodec codec, boolean blockMode) {
        this.codec = codec;
        this.encodedChannel = seekable;
        this.blockMode = blockMode;
        this.resetTracker();
    }

    public void ensureDecodedChannel() throws IOException {
        if (this.decodedChannel == null) {
            SeekableReadableChannel closeShieldedChannel = SeekableReadableChannels.closeShield(this.encodedChannel);
            SeekableInputStream seekableIn = SeekableInputStreams.create((SeekableReadableChannel<byte[]>)closeShieldedChannel);
            this.decodedIn = this.codec.createInputStream((InputStream)((Object)seekableIn), null, this.decodedChannelStart, Long.MAX_VALUE, SplittableCompressionCodec.READ_MODE.BYBLOCK);
            this.decodedChannel = SeekableInputStreams.advertiseEndOfBlock((InputStream)this.decodedIn);
        }
    }

    protected void resetTracker() {
        this.positionInBlock = 0;
        this.pendingRead.position(1);
    }

    public long getStartingBlockId() throws IOException {
        this.ensureDecodedChannel();
        return this.decodedChannel.getStartPos();
    }

    public long getCurrentBlockId() throws IOException {
        this.ensureDecodedChannel();
        return this.decodedChannel.getCurrentPos();
    }

    public int getPositionInBlock() {
        return this.positionInBlock;
    }

    public boolean adjustToNextBlock() throws IOException {
        return this.decodedChannel.adjustToNextBlock();
    }

    protected void closeDecodedChannel() throws IOException {
        if (this.decodedChannel != null) {
            this.decodedChannel.close();
            this.decodedChannel = null;
        }
        this.resetTracker();
    }

    public void close() throws IOException {
        this.closeDecodedChannel();
        this.encodedChannel.close();
    }

    public boolean isOpen() {
        return this.encodedChannel.isOpen();
    }

    public int read(byte[] array, int position, int length) throws IOException {
        this.ensureDecodedChannel();
        int result = this.decodedChannel.read(array, position, length);
        if (!this.blockMode && result == -2 && (result = this.decodedChannel.read(array, position, length)) == -2) {
            throw new RuntimeException("Consecutive block ends");
        }
        return result;
    }

    public long position() throws IOException {
        return this.decodedChannel == null ? this.decodedChannelStart : this.decodedChannel.position();
    }

    public void position(long newPosition) throws IOException {
        this.closeDecodedChannel();
        this.decodedChannelStart = newPosition;
    }

    public ArrayOps<byte[]> getArrayOps() {
        return ArrayOps.BYTE;
    }

    public SeekableReadableChannel<byte[]> cloneObject() {
        throw new UnsupportedOperationException();
    }
}

